/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 * A very basic simulated filter clamp module.
 * It has no sensor to know if the clamp is locked or not.
 * This clamp is locked when the clamps actuator of the carousel are off.
 * And its filter presence sensor is configured to returns the value we expect!
 * 
 * @author virieux
 */
public abstract class SimuFilterClampModule extends FilterClampModule {

   
    protected CarouselModule carousel;
    protected Filter dummyFilter;
    //TODO just for tests (cf tick method). 
    private BasicAutoChangerModule autochanger;

    //FOR SPRING
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    //FOR SPRING
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }
    

    @Override
    public double updateTemperature() {
        throw new UnsupportedOperationException(getName() + "updateTYemperature : Not supported yet.");
    }


    @Override
    public void initModule() {
        this.carousel = (CarouselModule) this.getModule("carousel");
        this.autochanger = (BasicAutoChangerModule) this.getModule("autochanger");
        
        this.filterPresenceStatus = FilterPresenceStatus.LOCKABLE;

        this.clampState = FilterClampState.CLAMPEDONFILTER;
        //((SimuSensor14bits) getFilterPresenceSensor()).setNewRange(getFilterPositionValueA(), getFilterPositionValueB());
        ((SimuClampFilterPresenceSensor) getFilterPresenceSensor()).simulateFilterIsLockable(this);
        //simu clamp is LOCKED
        //((SimuSensor14bits) getLockSensor()).setNewRange(this.getLockSensorValueB(),this.getLockSensorValueC());
        ((SimuClampLockSensor) getLockSensor()).simulateClampIsLOCKED(this);
        this.setLockStatus(LockStatus.LOCKED);
    }
    
    public void updateStateWithSensors() throws HardwareException {
        updateStateWithSensorsFromSDO();
    }
    
}
