/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

/**
 * This exception is thrown when the detected node ID of a piece of hardware identified by its serial number
 * doesn't match the node ID that is in the configuration DB.
 * @author virieux
 */
public class NodeIDMismatchException extends HardwareConfigurationException {
    String nodeIDFound;
    String serialNumberFound;

    /**
    * Constructs an instance of <code>NodeIDMismatchException</code> with the specified detail message.
    * @param msg the detail message.
    */

    
    public NodeIDMismatchException(PieceOfHardware aPieceOfHardware, String nodeID, String serial) {
        super();
        this.pieceOfHardware = aPieceOfHardware;
        this.nodeIDFound = nodeID;
        this.serialNumberFound = serial;
          
    }
    
    public NodeIDMismatchException(String msg, PieceOfHardware aPieceOfHardware, String nodeID, String serial) {
        super(msg);
        this.hardwareName = aPieceOfHardware.getName();
        this.pieceOfHardware = aPieceOfHardware;
        this.nodeIDFound = nodeID;
        this.serialNumberFound = serial;
    }
}
