/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

/**
 * This exception is thrown when we detect an error in the configuration of the hardware.
 * @author virieux
 */
public class HardwareConfigurationException extends HardwareException {
    PieceOfHardware pieceOfHardware;
    
    
    public HardwareConfigurationException() {
        super();
    }
    
    public HardwareConfigurationException(String msg) {
        super(msg);
    }
    
    public HardwareConfigurationException(String msg, String name) {
        super(msg);
        this.hardwareName = name;
    }

    public HardwareConfigurationException(String msg, PieceOfHardware pieceOfHardware) {
        super(msg, pieceOfHardware.getName());
        this.pieceOfHardware = pieceOfHardware;
    }
    
 
    
//    @Override
//    public String toString() {
//        StringBuilder sb = new StringBuilder(super.toString());
//        if (!(this.hardwareName==null)) sb.append("Name of hardware : ").append(hardwareName);
//        return sb.toString();
//    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Error in hardware configuration: ");
        sb.append(this.pieceOfHardware.toString());
        return sb.toString();
    }
    
    
    
}
