/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

/**
 * This is a model for a motor which unlocks a clamps on the carousel in the Single filter test.
 * @author virieux
 */
public class Motor {
    
    private String name;
   
    
    /*Type of the motor FORMAT=decimal*/
    private int motorType;
    
    /*Sensor Configuration*/
    private int positionSensorType;
    
    /*motor parameters for Velocity mode*/
    int maxProfileVelocity;
    int maxAcceleration;
    
    /*motor parameters for Current mode*/
    private int continuousCurrentLimit; /*UNIT= mA* FORMAT=decimal*/
    private int maxSpeedInCurrentMode; /*UNIT= rpm* FORMAT=decimal*/
    private int thermalTimeConstantWinding; /*100 ms* FORMAT=decimal*/
    private int outputCurrentLimit; /*100 mA* FORMAT=decimal*/
    private int polePairNumber; /* no unit FORMAT=decimal*/
    
    /**The value of current that has to be sent to the motor to make it move.
     * UNIT= mA given in decimal mode
     */
    private int currentValue; 
    /**
     * The value of current that has to be sent to the motor to maintain a position.
     * It's used for the filter clamp to maintain the clamp unlocked with a lower value 
     * of current than the one which has permit to unlock.
     */
    private int currentValueToMaintain;
    protected int velocityValue;
    
//    //For SPRING
//    public Motor() {
//    }
    
    /*A constructor to create a motor with current values set to zero*/
    public Motor() {
        this.currentValue = 0;
        this.velocityValue = 0;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the motorType
     */
    public int getMotorType() {
        return motorType;
    }

    /**
     * @param motorType the motorType to set
     */
    public void setMotorType(int motorType) {
        this.motorType = motorType;
    }

    /**
     * @return the positionSensorType
     */
    public int getPositionSensorType() {
        return positionSensorType;
    }

    /**
     * @param positionSensorType the positionSensorType to set
     */
    public void setPositionSensorType(int positionSensorType) {
        this.positionSensorType = positionSensorType;
    }

    /**
     * @return the continuousCurrentLimit
     */
    public int getContinuousCurrentLimit() {
        return continuousCurrentLimit;
    }

    /**
     * @param continuousCurrentLimit the continuousCurrentLimit to set
     */
    public void setContinuousCurrentLimit(int continuousCurrentLimit) {
        this.continuousCurrentLimit = continuousCurrentLimit;
    }

    /**
     * @return the maxSpeedInCurrentMode
     */
    public int getMaxSpeedInCurrentMode() {
        return maxSpeedInCurrentMode;
    }

    /**
     * @param maxSpeedInCurrentMode the maxSpeedInCurrentMode to set
     */
    public void setMaxSpeedInCurrentMode(int maxSpeedInCurrentMode) {
        this.maxSpeedInCurrentMode = maxSpeedInCurrentMode;
    }

    /**
     * @return the thermalTimeConstantWinding
     */
    public int getThermalTimeConstantWinding() {
        return thermalTimeConstantWinding;
    }

    /**
     * @param thermalTimeConstantWinding the thermalTimeConstantWinding to set
     */
    public void setThermalTimeConstantWinding(int thermalTimeConstantWinding) {
        this.thermalTimeConstantWinding = thermalTimeConstantWinding;
    }

    /**
     * @return the outputCurrentLimit
     */
    public int getOutputCurrentLimit() {
        return outputCurrentLimit;
    }

    /**
     * @param outputCurrentLimit the outputCurrentLimit to set
     */
    public void setOutputCurrentLimit(int outputCurrentLimit) {
        this.outputCurrentLimit = outputCurrentLimit;
    }

    /**
     * @return the polePairNumber
     */
    public int getPolePairNumber() {
        return polePairNumber;
    }

    /**
     * @param polePairNumber the polePairNumber to set
     */
    public void setPolePairNumber(int polePairNumber) {
        this.polePairNumber = polePairNumber;
    }

    /**
     * @return the currentValue
     */
    public int getCurrentValue() {
        return currentValue;
    }

    /**
     * @param currentValue the currentValue to set
     */
    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public int getCurrentValueToMaintain() {
        return currentValueToMaintain;
    }

    public void setCurrentValueToMaintain(int currentValueToMaintain) {
        this.currentValueToMaintain = currentValueToMaintain;
    }
    
    
    
}
