package org.lsst.ccs.subsystems.fcs.common;



public interface Motor {
	
	public String getName();
	
	public void move(double displacement, RunningWay runningWay);
	
	public void move(double displacement);
	
	public void stop();
	
	String getSerialNumber();

	void setSerialNumber(String serialNumber);

	double getMaximalVelocity();

	void setMaximalVelocity(double maximalVelocity);

	double getNominalVelocity();

	void setNominalVelocity(double nominalVelocity);

	public double getPosition();

	public void setEngineState(EngineState engineState);
	
	public EngineState getEngineState();

	public void setStateChangeTime(long currentTimeMillis);
	
	public long getStateChangeTime();

	public void setPeriod(double d);
	
	public double getPeriod();
	
	public double getRequiredPosition();

	public void setRequiredPosition(double requiredPosition);

	public double getMinimalPosition();

	public void setMinimalPosition(double p);

	public double getMaximalPosition();

	public void setMaximalPosition(double p);

    /**
     * To be overrided in each subclasses.
     * @param inc
     */
    void incrementPosition(final double inc);

}
