/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;
import org.lsst.ccs.subsystems.fcs.drivers.ApcTcpProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.errors.ErrorInBootingHardwareProcess;
import org.lsst.ccs.subsystems.fcs.errors.ProxyTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCError;

public class TestBenchMainModule
extends Module {
    private ApcTcpProxy tcpProxy;
    private String myClientName = "APCTestBench";
    private int nodeNB = 2;
    private int bootednodeNB = 0;
    private int infoNB = 0;
    private CanOpenNode[] nodes = new CanOpenNode[this.nodeNB];
    private boolean hardwareBooted = false;
    private boolean adcInitialized = false;
    private static double adcVoltsPerBit = 0.3125;
    private static double waterFreezeTemp = 273.15;

    public ApcTcpProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public void setTcpProxy(ApcTcpProxy myTcpProxy) {
        this.tcpProxy = myTcpProxy;
    }

    public String getMyClientName() {
        return this.myClientName;
    }

    public void setMyClientName(String myClientName) {
        this.myClientName = myClientName;
    }

    public void initModule() {
        this.nodes = new CanOpenNode[this.nodeNB];
    }

    public void tick() {
        if (!this.hardwareBooted && this.tcpProxy.isReady(this.myClientName)) {
            try {
                this.bootHardware();
            }
            catch (ErrorInBootingHardwareProcess ex) {
                Logger.getLogger(TestBenchMainModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.hardwareBooted && !this.adcInitialized) {
            try {
                this.initADC(1);
                this.adcInitialized = true;
                Module.log.debug((Object)"ADC is initialized");
            }
            catch (ReadingADCError ex) {
                Logger.getLogger(TestBenchMainModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public int getReturnValue(String responseLine, int inputNB) throws ReadingADCError {
        if (inputNB < 1 || inputNB > 8) {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        String cfr_ignored_0 = words[0];
        Module.log.debug((Object)("Value in HEXA:" + words[inputNB]));
        int value = Integer.parseInt(words[inputNB], 16);
        Module.log.debug((Object)("Value in decimal:" + words[inputNB]));
        return value;
    }

    public double readTemperature() throws ReadingADCError {
        int value = this.getReturnValue(this.readADC(), 1);
        Module.log.debug((Object)"Input Value read on the ADC:");
        double voltage = (double)value * adcVoltsPerBit;
        Module.log.debug((Object)("Voltage = " + voltage + " volts"));
        double temperature = voltage / 10.0 - waterFreezeTemp;
        return temperature;
    }

    public String readADC() throws ReadingADCError {
        Object response = null;
        Module.log.debug((Object)("Nom du client= " + this.myClientName));
        if (!this.tcpProxy.isReady(this.myClientName)) {
            throw new HardwareControlNotReady(this.myClientName);
        }
        response = this.getTcpProxy().call(this.myClientName, "adc,");
        if (response instanceof String) {
            Module.log.debug((Object)("Reponse= " + response));
            return (String)response;
        }
        throw new ReadingADCError(response);
    }

    public String readFromSocket(String clientName) throws ProxyTimeoutException {
        String response = null;
        int timeout = 1000;
        response = this.tcpProxy.readFromSocket(clientName, timeout);
        Module.log.debug((Object)("READ Reponse= " + response));
        return response;
    }

    public void turnOnLED() {
        if (!this.tcpProxy.isReady(this.myClientName)) {
            throw new HardwareControlNotReady(this.getMyClientName());
        }
        this.getTcpProxy().call(this.getMyClientName(), "dac,3000,0000,0000,0000");
    }

    public void turnOffLED() {
        if (!this.tcpProxy.isReady(this.myClientName)) {
            throw new HardwareControlNotReady(this.getMyClientName());
        }
        this.getTcpProxy().call(this.getMyClientName(), "dac,0,0,0,0");
    }

    public void stopAutomaticMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void stop() {
        this.getTcpProxy().stop();
    }

    private void bootHardware() throws ErrorInBootingHardwareProcess {
        while (this.bootednodeNB < this.nodeNB || this.infoNB < this.nodeNB) {
            try {
                int timeout = 1000;
                String bootLine = this.tcpProxy.readFromSocket(this.myClientName, timeout);
                String[] words = bootLine.split(",");
                String command = words[0];
                String nodeID = words[1];
                Module.log.debug((Object)("Received on socket command = " + command + "," + nodeID));
                if (command.equals("boot")) {
                    this.nodes[this.bootednodeNB] = new CanOpenNode(nodeID);
                    ++this.bootednodeNB;
                    Module.log.debug((Object)("Node " + nodeID + " added"));
                    Module.log.debug((Object)("Hardware booted nb=" + this.bootednodeNB));
                    continue;
                }
                if (!command.equals("info")) continue;
                String type = words[2];
                String vendor = words[3];
                String productCode = words[4];
                String revision = words[5];
                String serialNB = words[6];
                this.addNodeInfo(nodeID, type, vendor, productCode, revision, serialNB);
                ++this.infoNB;
                Module.log.debug((Object)("Node Info" + nodeID + " added"));
            }
            catch (ProxyTimeoutException ex) {
                Logger.getLogger(TestBenchMainModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void addNodeInfo(String nodeID, String type, String vendor, String productCode, String revision, String serialNB) throws ErrorInBootingHardwareProcess {
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(nodeID)) {
                this.nodes[i].setNodeInfo(type, vendor, productCode, revision, serialNB);
            }
            ++i;
        }
    }

    public String listNodes() {
        StringBuilder sb = new StringBuilder("Nodes LIST = ");
        int i = 0;
        while (i < this.nodes.length) {
            sb.append("\n");
            sb.append(this.nodes[i].toString());
            ++i;
        }
        Module.log.debug((Object)sb.toString());
        return sb.toString();
    }

    private void initADC(int syncNB) throws ReadingADCError {
        Object ack = this.getTcpProxy().call(this.getMyClientName(), "wsdo,1,1801,2,1,1");
        if (!(ack instanceof String)) {
            throw new ReadingADCError(ack);
        }
        Module.log.debug((Object)("initADC-step1 = " + ack));
        Object ack2 = this.getTcpProxy().call(this.getMyClientName(), "wsdo,1,1802,2,1,1");
        Module.log.debug((Object)("initADC-step2 = " + ack2));
    }

    public Object sendCanOpen(String command) {
        return this.getTcpProxy().call(this.getMyClientName(), command);
    }
}

