/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCError;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class APCTestBenchMainModule
extends Module {
    private CanOpenProxy tcpProxy;
    private CanOpenADC adc;
    private CanOpenDAC dac;
    private static double adcVoltsPerBit = 0.3125;
    private static double waterFreezeTemp = 273.15;

    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public void setTcpProxy(CanOpenProxy myTcpProxy) {
        this.tcpProxy = myTcpProxy;
    }

    public int getNodeNB() {
        return this.tcpProxy.getExpectedNodesNB();
    }

    public String getMyClientName() {
        return this.tcpProxy.getMyClientName();
    }

    public boolean isHardwareConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    public CanOpenADC getAdc() {
        return this.adc;
    }

    public void setAdc(CanOpenADC adc) {
        this.adc = adc;
    }

    public CanOpenDAC getDac() {
        return this.dac;
    }

    public void setDac(CanOpenDAC dac) {
        this.dac = dac;
    }

    public boolean isHardwareReady() {
        return this.tcpProxy.isHardwareReady();
    }

    public void initModule() {
        PieceOfHardware[] hardwareList1 = new PieceOfHardware[]{this.adc, this.dac};
        this.tcpProxy.hardwareList = hardwareList1;
        Module.log.debug((Object)("Number of pieces of hardware=" + hardwareList1.length));
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentError ex) {
            Module.log.error((Object)ex.getMessage());
            this.getSubsystem().updateState(State.InError, ex.getMessage());
        }
    }

    public void shutdown() {
        this.tcpProxy.stop();
        this.getSubsystem().shutdown();
    }

    public Object sendCanOpen(String command) throws InterruptedException, TimeoutException {
        return this.tcpProxy.sendCanOpen(command);
    }

    public int getReturnValue(String responseLine, int inputNB) throws ReadingADCError {
        if (inputNB < 1 || inputNB > 8) {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        String cfr_ignored_0 = words[0];
        Module.log.debug((Object)("Value in HEXA:" + words[inputNB]));
        int value = Integer.parseInt(words[inputNB], 16);
        Module.log.debug((Object)("Value in decimal:" + words[inputNB]));
        return value;
    }

    public double readTemperature() throws SDORequestError, HardwareNotDetectedException {
        String valueInHexa = this.adc.readAnalogInput(1);
        int value = Integer.parseInt(valueInHexa, 16);
        Module.log.debug((Object)"Input Value read on the ADC:");
        double voltage = (double)value * adcVoltsPerBit;
        Module.log.debug((Object)("Voltage = " + voltage + " volts"));
        double temperature = voltage / 10.0 - waterFreezeTemp;
        return temperature;
    }

    public String readADC() throws SDORequestError, TimeoutException {
        Module.log.debug((Object)("Client name = " + this.getMyClientName()));
        if (!this.tcpProxy.isHardwareReady()) {
            throw new HardwareControlNotReady(this.getMyClientName());
        }
        return this.adc.readInputs();
    }

    public void turnOnLED() throws InterruptedException, SDORequestError, HardwareNotDetectedException {
        if (!this.tcpProxy.isHardwareIdentified()) {
            throw new HardwareControlNotReady(this.getMyClientName());
        }
        this.dac.writeAnalogOutput(1, 14000);
    }

    public void turnOffLED() throws InterruptedException, SDORequestError {
        if (!this.tcpProxy.isHardwareIdentified()) {
            throw new HardwareControlNotReady(this.getMyClientName());
        }
        this.tcpProxy.writeSDO(this.dac.getNodeID(), "6411", "01", "2", "0");
    }

    private void initADC(int syncNB) throws ReadingADCError {
        try {
            Object ack = this.getTcpProxy().call(this.getMyClientName(), "wsdo,1,1801,2,1,1");
            if (!(ack instanceof String)) {
                throw new ReadingADCError(ack);
            }
            Module.log.debug((Object)("initADC-step1 = " + ack));
            Object ack2 = this.getTcpProxy().call(this.getMyClientName(), "wsdo,1,1802,2,1,1");
            Module.log.debug((Object)("initADC-step2 = " + ack2));
        }
        catch (TimeoutException ex) {
            Module.log.error((Object)ex.getMessage());
            throw new ReadingADCError((Object)ex);
        }
    }
}

