/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SftMainModule
extends Module {
    private Filter dummyFilter;
    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;
    private BridgeToHardware bridge;

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    public BridgeToHardware getBridge() {
        return this.bridge;
    }

    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public void initModule() {
        this.carousel = (SftCarouselModule)this.getModule("carousel");
        this.autochanger = (SftAutoChangerModule)this.getModule("autochanger");
        this.locateFilters();
    }

    private void locateFilters() {
        this.carousel.getSockets()[0].putFilterOnSocket(this.dummyFilter);
        this.carousel.engageClampsContact();
    }

    public String printFilters() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()) + " printFilters \n ");
        sb.append(this.dummyFilter.getName());
        sb.append(" position: ").append(this.carousel.getFilterPosition(this.dummyFilter));
        sb.append(" socket number: ").append(this.carousel.getSocketNumber(this.dummyFilter));
        sb.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(this.dummyFilter));
        Module.log.info((Object)sb.toString());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n").append(this.carousel.toString());
        sb.append("\n").append(this.autochanger.toString());
        return sb.toString();
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getContext().getSubsystem().getName()).append("\n  ");
        sb.append(CarouselModule.publishedByCarouselOutputName);
        Module.log.debug((Object)("Carousel status=" + this.carousel.getStatusData().toString()));
        sb.append(this.carousel.getStatusData().toString());
        sb.append("\n  ");
        sb.append("clampXminus status=");
        sb.append(this.carousel.getClampXminus().getStatusData().toString());
        sb.append("\n  ");
        sb.append("clampXplus status=");
        sb.append(this.carousel.getClampXplus().getStatusData().toString());
        sb.append("\n  ");
        sb.append(AutoChangerModule.publishedByAutoChangerOutputName);
        Module.log.debug((Object)("autochanger status=" + this.autochanger.getStatusData().toString()));
        sb.append(this.autochanger.getStatusData().toString());
        sb.append("\n  ");
        sb.append("latchXminus status=");
        sb.append(this.autochanger.getLatchXminus().getStatusData().toString());
        sb.append("\n  ");
        sb.append("latchXplus status=");
        sb.append(this.autochanger.getLatchXplus().getStatusData().toString());
        sb.append("\n  ");
        return sb.toString();
    }

    public String goToInitialStateForSequence1() {
        return null;
    }

    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        Module.log.debug((Object)"=======> Autochanger trucks moving empty to standby position.");
        this.autochanger.grabFilterAtStandby(this.dummyFilter);
        Module.log.debug((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabbeFilterAtStandby(this.dummyFilter);
        Module.log.debug((Object)"=======> Autochanger trucks moving loaded with the filter to standback position.");
        this.autochanger.moveFilterToStandback(this.dummyFilter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SftMainModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.carousel.releaseClamps();
        Module.log.debug((Object)"=======> Autochanger trucks moving back the filter to standby position.");
        this.autochanger.moveFilterToStandby(this.dummyFilter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SftMainModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        Module.log.debug((Object)"=======> Carousel is grabbing filter at standby position.");
        this.carousel.grabbeFilterAtStandby(this.getDummyFilter());
        Module.log.debug((Object)"=======> Autochanger moving back empty to online position.");
        this.autochanger.ungrabFilterAtStandby();
        return String.valueOf(this.getName()) + " Execution of Sequence1 completed";
    }

    public String executeSequence1(int nb) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        if (nb < 1 || nb > 20000) {
            throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        }
        int i = 1;
        while (i < nb) {
            Module.log.info((Object)("===========================Executing Sequence1 " + i + " times================"));
            this.executeSequence1();
            ++i;
        }
        return String.valueOf(this.getName()) + ":" + nb + " executions of Sequence1 completed";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.carousel.publishData(CarouselModule.publishedByCarouselOutputName, this.carousel.getStatusData());
        this.autochanger.publishData(BasicAutoChangerModule.publishedByAutoChangerOutputName, this.autochanger.getStatusData());
    }

    public SftCarouselModule getCarouselModule() {
        return this.carousel;
    }

    public SftAutoChangerModule getAutoChangerModule() {
        return this.autochanger;
    }

    public SingleFilterTestConfig getFullState() {
        return FcsUtils.createSingleFilterTestConfig(this);
    }
}

