/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class SftAutoChangerModule
extends BasicAutoChangerModule {
    protected SftTruckMotor sftTrucksMotor;
    private long timeToConfortAPosition;
    private long timeToGoToStandby;
    private long timeToGoToStandback;

    public SftTruckMotor getSftTrucksMotor() {
        return this.sftTrucksMotor;
    }

    public void setSftTrucksMotor(SftTruckMotor sftTrucksMotor) {
        this.sftTrucksMotor = sftTrucksMotor;
    }

    public long getTimeToConfortAPosition() {
        return this.timeToConfortAPosition;
    }

    public long getTimeToGoToStandback() {
        return this.timeToGoToStandback;
    }

    public long getTimeToGoToStandby() {
        return this.timeToGoToStandby;
    }

    public void setTimeToConfortAPosition(long timeToConfortAPosition) {
        this.timeToConfortAPosition = timeToConfortAPosition;
    }

    public void setTimeToGoToStandby(long timeToGoToStandby) {
        this.timeToGoToStandby = timeToGoToStandby;
    }

    public void setTimeToGoToStandback(long timeToGoToStandback) {
        this.timeToGoToStandback = timeToGoToStandback;
    }

    private Filter getFilterAtStandbyOnCarousel() {
        return ((SftMainModule)this.getModule("main")).getFilterAtStandby();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String stop() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void locateTrucks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isMoving() {
        return this.isMovingToStandback() || this.isMovingToStandby();
    }

    @Override
    public String goToStandback() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        Module.log.debug((Object)(String.valueOf(this.getName()) + " GOING TO STANDBACK POSITION"));
        this.checkPreConditionsForMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            return String.valueOf(this.getName()) + "trucks already at standback position";
        }
        if (this.isAtStandby()) {
            this.sftTrucksMotor.moveToStandby();
            try {
                Module.log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the position to be conforted"));
                Thread.sleep(this.timeToConfortAPosition);
            }
            catch (InterruptedException ex) {
                Module.log.debug((Object)ex);
            }
        }
        this.sftTrucksMotor.moveToStandback();
        this.setMovingToStandback(true);
        try {
            Module.log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the trucks to go to STANDBACK"));
            Thread.sleep(this.timeToGoToStandback);
        }
        catch (InterruptedException ex) {
            Module.log.debug((Object)ex);
        }
        this.sftTrucksMotor.off();
        this.setMovingToStandback(false);
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            Module.log.debug((Object)("====> " + this.getName() + "  IS AT STANDBACK POSITION"));
            return String.valueOf(this.getName()) + " IS AT STANDBACK POSITION";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "could not go to STANDBACK POSITION");
    }

    @Override
    public String goToStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        this.checkPreConditionsForMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            return String.valueOf(this.getName()) + "trucks already at standby position";
        }
        if (this.isAtStandback()) {
            this.sftTrucksMotor.moveToStandback();
            try {
                Module.log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the position to be conforted"));
                Thread.sleep(this.timeToConfortAPosition);
            }
            catch (InterruptedException ex) {
                Module.log.error((Object)ex);
            }
        }
        this.sftTrucksMotor.moveToStandby();
        this.setMovingToStandby(true);
        try {
            Module.log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the trucks to go to STANDBY"));
            Thread.sleep(this.timeToGoToStandby);
        }
        catch (InterruptedException ex) {
            Module.log.error((Object)ex);
        }
        this.sftTrucksMotor.off();
        this.setMovingToStandby(false);
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            Module.log.debug((Object)("====> " + this.getName() + "  IS AT STANDBY POSITION"));
            return String.valueOf(this.getName()) + " IS AT STANDBY POSITION";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " could not go to STANDBY POSITION");
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "/moveFilterToStandback: Autochanger is empty");
        }
        this.goToStandback();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return String.valueOf(this.getName()) + ": " + aFilter.getName() + " is at standback position.";
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "/moveFilterToStandby: Autochanger is empty");
        }
        this.goToStandby();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return String.valueOf(this.getName()) + ": " + aFilter.getName() + " is at standby position.";
    }

    @Override
    public String goToPosition(double trucksPositionOnline) throws BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getTrucksPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String moveFilterToOnline(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        return this.moveFilterToStandback(filter);
    }
}

