/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.simulation.SimuSensor14bits;

public abstract class SimuFilterClampModule
extends FilterClampModule {
    protected CarouselModule carousel;
    protected Filter dummyFilter;
    private BasicAutoChangerModule autochanger;

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    @Override
    public abstract boolean isLocked();

    @Override
    public double readTemperature() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initModule() {
        this.carousel = (CarouselModule)this.getModule("carousel");
        this.autochanger = (BasicAutoChangerModule)this.getModule("autochanger");
        this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ENGAGED;
        this.clampState = FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
        ((SimuSensor14bits)this.getFilterPresenceSensor()).setNewRange(this.getFilterPositionValueA(), this.getFilterPositionValueB());
        this.setLockStatus(FcsEnumerations.LockStatus.LOCKED);
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        Module.log.debug((Object)(String.valueOf(this.getName()) + "====> processUpdate from " + v.getName()));
        SimuSensor14bits sensor = (SimuSensor14bits)this.getFilterPresenceSensor();
        if (v.getValue() instanceof FcsEnumerations.AutoChangerTrucksLocation) {
            if (((FcsEnumerations.AutoChangerTrucksLocation)v.getValue()).equals((Object)FcsEnumerations.AutoChangerTrucksLocation.STANDBY) && this.dummyFilter.isOnAutoChanger()) {
                sensor.setNewRange(this.getFilterPositionValueA(), this.getFilterPositionValueB());
            } else if (((FcsEnumerations.AutoChangerTrucksLocation)v.getValue()).equals((Object)FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN)) {
                sensor.setNewRange(this.getFilterPositionValueC(), sensor.getMaxValue());
            } else if (((FcsEnumerations.AutoChangerTrucksLocation)v.getValue()).equals((Object)FcsEnumerations.AutoChangerTrucksLocation.STANDBACK) && this.dummyFilter.isOnAutoChanger()) {
                sensor.setNewRange(this.getFilterPositionValueC(), sensor.getMaxValue());
            }
        }
        this.updateStateWithSensors();
        Module.log.debug((Object)(String.valueOf(this.getName()) + " : filterPresence =" + this.filterPresenceStatus.toString()));
        StatusDataPublishedByClamp status = this.getStatusData();
        this.sendToStatus((Status)status);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.publishedByClampOutputName, (Object)status));
    }
}

