/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Random;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;

public class SimuClampActuatorModule
extends ClampActuatorModule {
    Random r = new Random();

    public void initModule() {
        this.on = false;
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        this.on = true;
        this.sendToStatus((Status)this.getStatusData());
        return String.valueOf(this.getName()) + " is turned ON.";
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        this.on = false;
        this.sentValue = 0;
        this.sendToStatus((Status)this.getStatusData());
        return String.valueOf(this.getName()) + " is turned OFF.";
    }

    @Override
    public int getSentValue() {
        if (this.getSentCurrentMinValue() >= 0) {
            return this.r.nextInt(this.getSentCurrentMaxValue());
        }
        return (int)this.r.nextGaussian() * this.getSentCurrentMaxValue() / 2;
    }

    public void tick() {
        this.sendToStatus((Status)this.getStatusData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }

    @Override
    public int getMotor_continuousCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_maxSpeedInCurrentMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMotor_mode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_outputCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_polePairNumber() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_thermalTimeConstantWinding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_type() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNodeID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPositionSensorType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSerialNB() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String maintainCurrent() throws BadCommandException, ErrorInCommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

