/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenSensor14bits
extends Sensor14bits {
    CanOpenADC adc;
    int numOfAnalogInput;

    public CanOpenADC getAdc() {
        return this.adc;
    }

    public void setAdc(CanOpenADC adc) {
        this.adc = adc;
    }

    public int getNumOfAnalogInput() {
        return this.numOfAnalogInput;
    }

    public void setNumOfAnalogInput(int numOfAnalogInput) {
        this.numOfAnalogInput = numOfAnalogInput;
    }

    @Override
    public int readNewValue() {
        try {
            String valueInHexa = this.adc.readAnalogInput(this.numOfAnalogInput);
            this.value = Integer.parseInt(valueInHexa, 16);
            return this.value;
        }
        catch (SDORequestError ex) {
            Module.log.error((Object)(String.valueOf(this.getName()) + " CanOpen Error in reading sensor " + ex.getMessage()));
            this.getSubsystem().updateState(State.InError, String.valueOf(this.getName()) + " CanOpen Error in reading sensor:" + ex.getMessage());
        }
        catch (HardwareNotDetectedException ex) {
            Module.log.error((Object)ex);
            this.getSubsystem().updateState(State.InError, String.valueOf(this.getName()) + " not booted or error in config." + ex.getMessage());
        }
        return 0;
    }
}

