/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenLatchActuatorModule
extends LatchActuatorModule {
    CanOpenDAC dac;
    int numOfAnalogOutputForSpeedVoltage;
    int numOfAnalogOutputForCurrentLimit;

    public int getNumOfAnalogOutputForSpeedVoltage() {
        return this.numOfAnalogOutputForSpeedVoltage;
    }

    public void setNumOfAnalogOutputForSpeedVoltage(int numOfAnalogOutputForSpeedVoltage) {
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
    }

    public int getNumOfAnalogOutputForCurrentLimit() {
        return this.numOfAnalogOutputForCurrentLimit;
    }

    public void setNumOfAnalogOutputForCurrentLimit(int numOfAnalogOutputForCurrentLimit) {
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }

    public CanOpenDAC getDac() {
        return this.dac;
    }

    public void setDac(CanOpenDAC dac) {
        this.dac = dac;
    }

    @Override
    public String open() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            int currentLimitInDecimal = (int)(this.getCurrentLimitInVolt() * 3210.27287);
            this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
            int speedVoltageInDecimal = (int)((double)this.getSpeedVoltageInVolt() * 3210.27287);
            this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, speedVoltageInDecimal);
        }
        catch (HardwareNotDetectedException hardwareNotDetectedException) {
            String message = String.valueOf(this.getName()) + " CANNOT BE TURNED ON";
            Module.log.error((Object)message);
            return message;
        }
        catch (SDORequestError sDORequestError) {
            String message = String.valueOf(this.getName()) + " CANNOT BE TURNED ON)";
            Module.log.error((Object)message);
            return message;
        }
        return String.valueOf(this.getName()) + " is OPEN";
    }

    @Override
    public String close() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            int currentLimitInDecimal = (int)(this.getCurrentLimitInVolt() * 3210.27287);
            this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
            int speedVoltageInDecimal = (int)((double)this.getSpeedVoltageInVolt() * 3210.27287);
            this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, -speedVoltageInDecimal);
        }
        catch (HardwareNotDetectedException hardwareNotDetectedException) {
            String message = String.valueOf(this.getName()) + " CANNOT BE TURNED OFF";
            Module.log.error((Object)message);
            return message;
        }
        catch (SDORequestError sDORequestError) {
            String message = String.valueOf(this.getName()) + " CANNOT BE TURNED OFF";
            Module.log.error((Object)message);
            return message;
        }
        return String.valueOf(this.getName()) + " is CLOSED";
    }

    @Override
    public String powerOff() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, 0);
            this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, 0);
            return String.valueOf(this.getName()) + " is POWER OFF";
        }
        catch (SDORequestError sDORequestError) {
            String message = String.valueOf(this.getName()) + " CANNOT BE POWERED OFF";
            Module.log.error((Object)message);
            return message;
        }
        catch (HardwareNotDetectedException hardwareNotDetectedException) {
            String message = String.valueOf(this.getName()) + " CANNOT BE POWERED OFF";
            Module.log.error((Object)message);
            return message;
        }
    }
}

