/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenFilterClampModule
extends FilterClampModule {
    CanOpenADC adc;
    int numOfAnalogInputForTemp;

    public CanOpenADC getAdc() {
        return this.adc;
    }

    public void setAdc(CanOpenADC adc) {
        this.adc = adc;
    }

    public int getNumOfAnalogInputForTemp() {
        return this.numOfAnalogInputForTemp;
    }

    public void setNumOfAnalogInputForTemp(int numOfAnalogInputForTemp) {
        this.numOfAnalogInputForTemp = numOfAnalogInputForTemp;
    }

    @Override
    public double readTemperature() {
        double temp = 0.0;
        try {
            String valueInHexa = this.adc.readAnalogInput(this.numOfAnalogInputForTemp);
            Module.log.debug((Object)("Value in HEXA=" + valueInHexa));
            int value = Integer.parseInt(valueInHexa, 16);
            double voltage = (double)value * 0.3125;
            Module.log.debug((Object)("Input Value read on the ADC:" + value));
            Module.log.debug((Object)("Voltage = " + voltage + " volts"));
            temp = voltage / 10.0 - 273.15;
            return temp;
        }
        catch (HardwareNotDetectedException ex) {
            Module.log.error((Object)ex);
            this.getSubsystem().updateState(State.InError, String.valueOf(this.getName()) + " not booted or error in config.");
        }
        catch (SDORequestError ex) {
            Module.log.error((Object)(String.valueOf(this.getName()) + " CanOpen Error in reading temperature " + ex.getMessage()));
            this.getSubsystem().updateState(State.InError, String.valueOf(this.getName()) + " CanOpen Error in reading temperature.");
        }
        return temp;
    }
}

