/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenDIO
extends CompactIOModule
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    String serialNB;
    String nodeID;

    public CanOpenDIO() {
    }

    public CanOpenDIO(String nodeID, String serial) {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.serialNB = serial;
        this.nodeID = nodeID;
    }

    @Override
    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public boolean isConfigOK() {
        return this.tcpProxy.isConfigOK(this);
    }

    public String writeDigitalOutput(int outputNB, int value) throws SDORequestError, HardwareNotDetectedException {
        if (!this.tcpProxy.isHardwareReady()) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.getName(), this.nodeID);
            Module.log.error((Object)message);
            throw new HardwareNotDetectedException(String.valueOf(this.getName()) + message);
        }
        if (outputNB < 1 || outputNB > 8) {
            throw new IllegalArgumentException("CAN-CBX-DIO8 : input has to be 1..8");
        }
        String valueInHexa = Integer.toHexString(value);
        String inputNBInHexa = Integer.toHexString(outputNB);
        return this.tcpProxy.writeSDO(this.nodeID, "6200", inputNBInHexa, "2", valueInHexa);
    }

    @Override
    public String readNewHexaValue() {
        try {
            return this.tcpProxy.readSDO(this.nodeID, "6000", "1");
        }
        catch (SDORequestError sDORequestError) {
            String message = String.valueOf(this.getName()) + ": ERROR IN READING SENSOR";
            Module.log.error((Object)message);
            this.getSubsystem().updateState(State.InError, String.valueOf(this.getName()) + ":CanOpen Error in reading sensor.");
            return null;
        }
    }

    public String writeMask() throws SDORequestError {
        return this.tcpProxy.writeSDO(this.nodeID, "2250", "1", "1", "3");
    }

    public boolean checkMask() throws SDORequestError {
        String maskValue = this.tcpProxy.readSDO(this.nodeID, "6000", "1");
        return maskValue.equals("3");
    }

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readNewValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

