/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class FilterClampModule
extends Module {
    ClampActuatorModule actuator;
    private Sensor14bits filterPresenceSensor;
    private Sensor14bits lockSensor;
    protected FcsEnumerations.FilterClampState clampState;
    protected FcsEnumerations.FilterPresenceStatus filterPresenceStatus;
    private FcsEnumerations.LockStatus lockStatus;
    protected int temperature;
    private int lockSensorValueA;
    private int lockSensorValueB;
    private int lockSensorValueC;
    private int lockSensorMinValue;
    private int lockSensorMaxValue;
    private int filterPositionMinValue;
    private int filterPositionMaxValue;
    private int filterPositionValueA;
    private int filterPositionValueB;
    private int filterPositionValueC;
    public String publishedByClampOutputName = "publishedByClamp";
    private boolean initialized = false;
    final Lock lock = new ReentrantLock();
    final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;

    public ClampActuatorModule getActuator() {
        return this.actuator;
    }

    public void setActuator(ClampActuatorModule actuator) {
        this.actuator = actuator;
    }

    public void setFilterPositionValueA(int valueA) {
        this.filterPositionValueA = valueA;
    }

    public void setFilterPositionValueB(int valueB) {
        this.filterPositionValueB = valueB;
    }

    public void setFilterPositionValueC(int valueC) {
        this.filterPositionValueC = valueC;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.FilterClampState getClampState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getLockSensorValueA() {
        return this.lockSensorValueA;
    }

    public void setLockSensorValueA(int aValue) {
        this.lockSensorValueA = aValue;
    }

    public int getLockSensorValueB() {
        return this.lockSensorValueB;
    }

    public void setLockSensorValueB(int aValue) {
        this.lockSensorValueB = aValue;
    }

    public int getLockSensorValueC() {
        return this.lockSensorValueC;
    }

    public void setLockSensorValueC(int lockSensorValueC) {
        this.lockSensorValueC = lockSensorValueC;
    }

    public int getFilterPositionMaxValue() {
        return this.filterPositionMaxValue;
    }

    public void setFilterPositionMaxValue(int filterPositionMaxValue) {
        this.filterPositionMaxValue = filterPositionMaxValue;
    }

    public int getFilterPositionMinValue() {
        return this.filterPositionMinValue;
    }

    public void setFilterPositionMinValue(int filterPositionMinValue) {
        this.filterPositionMinValue = filterPositionMinValue;
    }

    public int getLockSensorMaxValue() {
        return this.lockSensorMaxValue;
    }

    public void setLockSensorMaxValue(int lockSensorMaxValue) {
        this.lockSensorMaxValue = lockSensorMaxValue;
    }

    public int getLockSensorMinValue() {
        return this.lockSensorMinValue;
    }

    public void setLockSensorMinValue(int lockSensorMinValue) {
        this.lockSensorMinValue = lockSensorMinValue;
    }

    public int getFilterPositionValueA() {
        return this.filterPositionValueA;
    }

    public int getFilterPositionValueB() {
        return this.filterPositionValueB;
    }

    public int getFilterPositionValueC() {
        return this.filterPositionValueC;
    }

    public Sensor14bits getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public void setFilterPresenceSensor(Sensor14bits filterPresenceSensor) {
        this.filterPresenceSensor = filterPresenceSensor;
    }

    public Sensor14bits getLockSensor() {
        return this.lockSensor;
    }

    public void setLockSensor(Sensor14bits lockSensor) {
        this.lockSensor = lockSensor;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void initModule() {
        this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
        this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.UNKNOWN;
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.temperature = 0;
    }

    public abstract double readTemperature();

    public synchronized boolean isFilterEngaged() {
        return this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED);
    }

    public void updateStateWithSensors() {
        block12: {
            this.lock.lock();
            this.updatingState = true;
            try {
                try {
                    this.filterPresenceSensor.updateValue();
                    int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
                    if (newFilterPresenceSensorValue < this.filterPositionValueA) {
                        this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
                        this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
                        throw new SensorValueOutOfRangeException(this.filterPresenceSensor, newFilterPresenceSensorValue);
                    }
                    this.filterPresenceStatus = newFilterPresenceSensorValue < this.filterPositionValueB ? FcsEnumerations.FilterPresenceStatus.ENGAGED : (newFilterPresenceSensorValue < this.filterPositionValueC ? FcsEnumerations.FilterPresenceStatus.UNKNOWN : FcsEnumerations.FilterPresenceStatus.NOFILTER);
                    this.lockSensor.updateValue();
                    int newLockSensorValue = this.lockSensor.getValue();
                    Module.log.debug((Object)(String.valueOf(this.getName()) + " NEWVALUE FOR LOCK SENSOR=" + newLockSensorValue));
                    if (newLockSensorValue < this.lockSensorValueA) {
                        this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
                    } else if (newLockSensorValue <= this.lockSensorValueB) {
                        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
                    } else if (newLockSensorValue <= this.lockSensorValueC) {
                        this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
                    } else {
                        this.lockStatus = FcsEnumerations.LockStatus.ERROR;
                        Module.log.error((Object)(String.valueOf(this.getName()) + " ERROR new value read = " + newLockSensorValue));
                        throw new SensorValueOutOfRangeException(this.lockSensor, newFilterPresenceSensorValue);
                    }
                    this.clampState = this.computeClampState();
                }
                catch (SensorValueOutOfRangeException ex) {
                    Module.log.error((Object)ex.getMessage());
                    this.updatingState = false;
                    this.stateUpdated.signal();
                    this.lock.unlock();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.updatingState = false;
                this.stateUpdated.signal();
                this.lock.unlock();
                throw throwable;
            }
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.sendToStatus((Status)this.getStatusData());
    }

    public FcsEnumerations.FilterClampState computeClampState() {
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.ERROR) || this.lockStatus.equals((Object)FcsEnumerations.LockStatus.ERROR)) {
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
            }
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.READYTOCLAMP;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
            }
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        return FcsEnumerations.FilterClampState.UNDEFINED;
    }

    public void tick() {
        if (!this.initialized && ((BridgeToHardware)this.getModule("bridge")).isHardwareReady()) {
            this.initialized = true;
        }
    }

    public StatusDataPublishedByClamp getStatusData() {
        StatusDataPublishedByClamp status = FcsUtils.createStatusDataPublishedByClamp(this);
        return status;
    }

    public String release() throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.debug((Object)("Releasing " + this.getName() + " on socket at standby position."));
        this.updateStateWithSensors();
        if (!this.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY)) {
            throw new BadCommandException("Can't release a clamp if isn't unclamped and empty.");
        }
        this.actuator.off();
        this.updateStateWithSensors();
        while (this.updatingState) {
            try {
                this.stateUpdated.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
            return String.valueOf(this.getName()) + " is released";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Could not release clamp.");
    }

    public String unlock() throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.debug((Object)(String.valueOf(this.getName()) + ": " + "UNLOCK State1 = " + this.clampState.toString()));
        this.updateStateWithSensors();
        if (!this.getClampState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER)) {
            throw new BadCommandException("Can't unlock a clamp if isn't clamped on filter.");
        }
        this.actuator.on();
        this.updateStateWithSensors();
        while (this.updatingState) {
            try {
                this.stateUpdated.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Module.log.debug((Object)(String.valueOf(this.getName()) + ":UNLOCK State2 = " + this.clampState.toString()));
        if (this.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            this.actuator.maintainCurrent();
            return String.valueOf(this.getName()) + " is unlocked";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Could not unlock clamp.");
    }
}

