/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.TruckModule;
import org.lsst.ccs.subsystems.fcs.common.AutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class BasicAutoChangerModule
extends Module
implements AutoChanger {
    private boolean trucksEmpty;
    Filter filterOnTrucks;
    Filter filterToGrab;
    FcsEnumerations.AutoChangerTrucksLocation trucksLocation;
    private FilterLatchModule latchXminus;
    private FilterLatchModule latchXplus;
    protected TruckModule truckXminus;
    protected TruckModule truckXplus;
    CompactIOModule railsSensorsDIO;
    CompactIOModule filterSensorsDIO;
    public static String publishedByAutoChangerOutputName = "publishedByAutoChanger";
    protected volatile ModuleState state = ModuleState.HALTED;
    private volatile FcsEnumerations.LockStatus latchesState;
    private boolean initialized = false;
    volatile boolean movingToStandby;
    volatile boolean movingToStandback;
    protected volatile boolean updatingLatches = false;
    protected volatile boolean lockingLatches = false;
    protected volatile boolean unlockingLatches = false;
    private volatile boolean updatingTrucksLocation = false;
    final Lock lock = new ReentrantLock();
    final Condition stateUpdated = this.lock.newCondition();
    final Condition lockCompleted = this.lock.newCondition();
    final Condition unlockCompleted = this.lock.newCondition();
    final Condition trucksLocationUpdated = this.lock.newCondition();

    public CompactIOModule getRailsSensorsDIO() {
        return this.railsSensorsDIO;
    }

    public void setRailsSensorsDIO(CompactIOModule railsSensorsDIO) {
        this.railsSensorsDIO = railsSensorsDIO;
    }

    public CompactIOModule getFilterSensorsDIO() {
        return this.filterSensorsDIO;
    }

    public void setFilterSensorsDIO(CompactIOModule filterSensorsDIO) {
        this.filterSensorsDIO = filterSensorsDIO;
    }

    @Override
    public Filter getFilterOnTrucks() {
        return this.filterOnTrucks;
    }

    public ModuleState getState() {
        return this.state;
    }

    public void setState(ModuleState state) {
        this.state = state;
    }

    public FilterLatchModule getLatchXminus() {
        return this.latchXminus;
    }

    public void setLatchXminus(FilterLatchModule latchXminus) {
        this.latchXminus = latchXminus;
    }

    public FilterLatchModule getLatchXplus() {
        return this.latchXplus;
    }

    public void setLatchXplus(FilterLatchModule latchXplus) {
        this.latchXplus = latchXplus;
    }

    public TruckModule getTruckXminus() {
        return this.truckXminus;
    }

    public void setTruckXminus(TruckModule truckXminus) {
        this.truckXminus = truckXminus;
    }

    public TruckModule getTruckXplus() {
        return this.truckXplus;
    }

    public void setTruckXplus(TruckModule truckXplus) {
        this.truckXplus = truckXplus;
    }

    public boolean isTrucksEmpty() {
        return this.trucksEmpty;
    }

    public void setTrucksEmpty(boolean isEmpty) {
        this.trucksEmpty = isEmpty;
    }

    public void setFilterOnTrucks(Filter filterOnTrucks) {
        this.filterOnTrucks = filterOnTrucks;
    }

    public String getFilterOnTrucksName() {
        if (this.filterOnTrucks == null) {
            return "none";
        }
        return this.filterOnTrucks.getName();
    }

    public boolean isMovingToStandback() {
        return this.movingToStandback;
    }

    public void setMovingToStandback(boolean movingToStandback) {
        this.movingToStandback = movingToStandback;
    }

    public boolean isMovingToStandby() {
        return this.movingToStandby;
    }

    public void setMovingToStandby(boolean movingToStandby) {
        this.movingToStandby = movingToStandby;
    }

    public void initModule() {
        Module.log.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ");
        this.trucksLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
        this.latchesState = FcsEnumerations.LockStatus.UNKNOWN;
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.publishDataAndNotifyObservers();
    }

    public StatusDataPublishedByBasicAutoChanger getStatusData() {
        return FcsUtils.createStatusDataPublishedByBasicAutoChanger(this);
    }

    public void publishDataAndNotifyObservers() {
        StatusDataPublishedByBasicAutoChanger status = this.getStatusData();
        this.sendToStatus((Status)status);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByAutoChangerOutputName, (Object)status));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n");
        sb.append("Trucks position = ");
        sb.append("Filter on trucks:");
        if (this.filterOnTrucks == null) {
            sb.append(" NONE").append("\n");
        } else {
            sb.append(this.filterOnTrucks.getName()).append("\n");
        }
        return sb.toString();
    }

    public abstract boolean isMoving();

    public abstract String goToStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError;

    public abstract String goToStandback() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError;

    @Override
    public abstract String moveFilterToStandby(Filter var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError;

    public abstract String moveFilterToStandback(Filter var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError;

    public void checkPreConditionsForMotion() throws BadCommandException, HardwareErrorDetectedException, ErrorInCommandExecutionException {
        Module.log.debug((Object)"Checking pre-conditions for motion");
        this.updateLatchesStateWithSensors();
        Module.log.debug((Object)(String.valueOf(this.getName()) + " LATCHES STATUS= " + this.latchesState.toString()));
        Module.log.debug((Object)("LATCHX- is LOCKED=" + this.latchXminus.isLocked()));
        Module.log.debug((Object)("LATCHX+ is LOCKED=" + this.latchXplus.isLocked()));
        Module.log.debug((Object)("LATCHX- is UNLOCKED=" + this.latchXminus.isUnlocked()));
        Module.log.debug((Object)("LATCHX+ is UNLOCKED=" + this.latchXplus.isUnlocked()));
        Module.log.debug((Object)("LATCHX- status=" + this.latchXminus.getLockStatus()));
        Module.log.debug((Object)("LATCHX+ status=" + this.latchXminus.getLockStatus()));
        if (this.latchesState == FcsEnumerations.LockStatus.ERROR) {
            throw new BadCommandException(String.valueOf(this.getName()) + "Trucks motion forbidden when latches are in ERROR.");
        }
        if (this.latchesState == FcsEnumerations.LockStatus.UNKNOWN) {
            throw new BadCommandException(String.valueOf(this.getName()) + "Trucks motion forbidden when latches status is in UNKNOWN.");
        }
        if (!this.trucksEmpty && this.latchesState == FcsEnumerations.LockStatus.UNLOCKED) {
            throw new BadCommandException(String.valueOf(this.getName()) + "Trucks motion forbidden when trucks are loaded and latches are UNLOCKED.");
        }
        Module.log.debug((Object)"===== Preconditions for motion are checked.");
    }

    @Override
    public String grabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        if (this.filterOnTrucks != null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": can't grabbe a filter " + "when a filter is already loaded in trucks ");
        }
        Module.log.debug((Object)(String.valueOf(this.getName()) + ": grabbing " + filter.getName() + " at standby position."));
        this.goToStandby();
        this.lockLatchesAtStandby(filter);
        String ack = String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed on autochanger";
        Module.log.info((Object)ack);
        return ack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ungrabFilterAtStandby() throws ErrorInCommandExecutionException, BadCommandException, HardwareErrorDetectedException, CanOpenError {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": ungrabbing filter at standby position."));
        this.unlockLatchesAtStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = null;
            this.setTrucksEmpty(true);
            this.publishDataAndNotifyObservers();
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + " trucks going empty to SWAPOUT position"));
        this.goToStandback();
        String ack = String.valueOf(this.getName()) + ": trucks are empty at SWAPOUT position ";
        return ack;
    }

    @Override
    public String unlockLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        this.lock.lock();
        this.unlockingLatches = true;
        try {
            this.latchXminus.open();
            this.latchXplus.open();
            if (this.latchXminus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED) && this.latchXplus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                this.latchesState = this.latchXminus.getLockStatus();
                System.out.println("XXXXXXX AUTOCHANGER : latches are unlocked");
            } else {
                if (!this.latchXminus.getLockStatus().equals((Object)this.latchXplus.getLockStatus())) {
                    throw new HardwareErrorDetectedException(String.valueOf(this.getName()) + "Error in latches lock status : " + "the latches don't agree.");
                }
                if (!this.latchXminus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                    throw new ErrorInCommandExecutionException("Could not unlock latchX-");
                }
                if (!this.latchXplus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                    throw new ErrorInCommandExecutionException("Could not unlock latchX+");
                }
            }
        }
        finally {
            this.unlockingLatches = false;
            this.unlockCompleted.signal();
            this.lock.unlock();
        }
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are unlocked";
    }

    @Override
    public String lockLatchesAtStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        this.lock.lock();
        this.lockingLatches = true;
        this.filterToGrab = aFilter;
        try {
            this.latchXminus.close();
            this.latchXplus.close();
            if (this.latchXminus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED) && this.latchXplus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                this.latchesState = this.latchXminus.getLockStatus();
                System.out.println("XXXXXXX AUTOCHANGER : latches are locked");
                this.filterOnTrucks = this.filterToGrab;
                this.setTrucksEmpty(false);
                this.filterOnTrucks.setFilterLocation(FilterLocation.ONAUTOCHANGER);
            } else {
                if (!this.latchXminus.getLockStatus().equals((Object)this.latchXplus.getLockStatus())) {
                    throw new HardwareErrorDetectedException(String.valueOf(this.getName()) + "Error in latches lock status : " + "the latches don't agree.");
                }
                if (!this.latchXminus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                    throw new ErrorInCommandExecutionException("Could not lock latchX-");
                }
                if (!this.latchXplus.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                    throw new ErrorInCommandExecutionException("Could not lock latchX+");
                }
            }
        }
        finally {
            this.lockingLatches = false;
            this.lockCompleted.signal();
            this.lock.unlock();
        }
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are locked";
    }

    public void updateLatchesStateWithSensors() throws HardwareErrorDetectedException, ErrorInCommandExecutionException {
        block4: {
            this.lock.lock();
            this.updatingLatches = true;
            try {
                this.filterSensorsDIO.updateValue();
                String filterSensorsHexaValue = this.filterSensorsDIO.getHexaValue();
                this.latchXminus.updateState(filterSensorsHexaValue);
                this.latchXplus.updateState(filterSensorsHexaValue);
                if (this.latchXminus.getLockStatus().equals((Object)this.latchXplus.getLockStatus())) {
                    this.latchesState = this.latchXminus.getLockStatus();
                    System.out.println("XXXXXXX AUTOCHANGER : latches are updated");
                    break block4;
                }
                throw new HardwareErrorDetectedException(String.valueOf(this.getName()) + "Error in latches lock status : " + "the latches don't agree.");
            }
            finally {
                this.updatingLatches = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
        this.publishDataAndNotifyObservers();
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.AutoChangerTrucksLocation getTrucksLocation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isAtStandby() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBY;
    }

    public boolean isAtStandback() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBACK;
    }

    public void updateTrucksLocationWithSensors() throws ErrorInCommandExecutionException {
        block4: {
            this.lock.lock();
            this.updatingTrucksLocation = false;
            try {
                this.railsSensorsDIO.updateValue();
                String dioHexaValue = this.railsSensorsDIO.getHexaValue();
                Module.log.debug((Object)(String.valueOf(this.railsSensorsDIO.getName()) + " HEXA VALUE=" + dioHexaValue));
                this.truckXminus.updateLocation(dioHexaValue);
                this.truckXplus.updateLocation(dioHexaValue);
                if (this.truckXminus.getTruckLocation() == this.truckXplus.getTruckLocation()) {
                    this.trucksLocation = this.truckXminus.getTruckLocation();
                    break block4;
                }
                String msg = String.valueOf(this.getName()) + "Trucks are not at the same location";
                Module.log.error((Object)msg);
                throw new ErrorInCommandExecutionException(msg);
            }
            finally {
                this.updatingTrucksLocation = false;
                this.trucksLocationUpdated.signal();
                this.lock.unlock();
            }
        }
        this.publishDataAndNotifyObservers();
    }
}

