/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;

/**
 * This class is for the Single Filter Test autochanger.
 * The autochanger in Single Filter Test has no flip rail and
 * no online clamp.
 * 
 * To move the autochanger trucks in the Single Filter Test we have 
 * 2 pneumatic cylinders each moved by an actuator : 
 * when we want the truck to be in stanby position, the standby actuator has to be ON
 * and the standback actuator has to be OFF,
 * when we want the truck to be in standback position, the standback actuator has to be ON 
 * and the standby actuator has to be OFF.
 *
 * @author virieux
 */
public class SftAutoChangerModule extends BasicAutoChangerModule {

    
    protected SftTruckMotor sftTrucksMotor;
   
    
    private long timeToConfortAPosition; //in millisecond
    private long timeToGoToStandby; //in millisecond
    private long timeToGoToStandback; //in millisecond




    

    
    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/

    public SftTruckMotor getSftTrucksMotor() {
        return sftTrucksMotor;
    }

    public void setSftTrucksMotor(SftTruckMotor sftTrucksMotor) {
        this.sftTrucksMotor = sftTrucksMotor;
    }

    
    //Used by SimuActuatorModule
    public long getTimeToConfortAPosition() {
        return timeToConfortAPosition;
    }

    //Used by SimuActuatorModule
    public long getTimeToGoToStandback() {
        return timeToGoToStandback;
    }

    //Used by SimuActuatorModule
    public long getTimeToGoToStandby() {
        return timeToGoToStandby;
    }

    public void setTimeToConfortAPosition(long timeToConfortAPosition) {
        this.timeToConfortAPosition = timeToConfortAPosition;
    }

    public void setTimeToGoToStandby(long timeToGoToStandby) {
        this.timeToGoToStandby = timeToGoToStandby;
    }

    public void setTimeToGoToStandback(long timeToGoToStandback) {
        this.timeToGoToStandback = timeToGoToStandback;
    }
    
    
    
    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/

       
  
    

    

    private Filter getFilterAtStandbyOnCarousel() {
        return ((SftMainModule) this.getModule("main")).getFilterAtStandby();
    }
  
    @Override
    public String toString() {
        return getName();
    }
  

    public String stop() {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    @Override
    public void locateTrucks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    @Override
    public boolean isMoving() {
        return isMovingToStandback() || isMovingToStandby();
    }

  
    @Override
    public String goToStandback() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        log.debug(getName() + " GOING TO STANDBACK POSITION");
        checkPreConditionsForMotion();
        updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            return getName() + "trucks already at standback position";
        }
        // to confort the position at standby
        if (this.isAtStandby()) {
            sftTrucksMotor.moveToStandby();
            try {
                log.debug(getName() + ": Waiting for the position to be conforted");
                Thread.sleep(timeToConfortAPosition);
            } catch (InterruptedException ex) {
                log.debug(ex);
            }
        }
        //TODO : and what if the trucks are in UNKNOWN position ?
        //TODO : if trucks at ERROR position , put the subsystem in error.
        sftTrucksMotor.moveToStandback();
        
        setMovingToStandback(true);
        try {
            log.debug(getName() + ": Waiting for the trucks to go to STANDBACK");
            Thread.sleep(timeToGoToStandback);
        } catch (InterruptedException ex) {
            log.debug(ex);
        }
        this.sftTrucksMotor.off();
        setMovingToStandback(false);
        
        updateTrucksLocationWithSensors();
        
        if (this.isAtStandback()) {          
            log.debug("====> " + getName() + "  IS AT STANDBACK POSITION");
            return getName() + " IS AT STANDBACK POSITION";
        } else {
            throw new ErrorInCommandExecutionException(getName() + "could not go to STANDBACK POSITION");
        }
    }

    /**
     * This methods moves the trucks from standback position to standby position.
     * It first checks the preconditions for a motion of the trucks.
     * Then it checks if the trucks are in standback position otherwise throws a BadCommandException.
     * If the trucks are at standback, it first conforts the position (standbackMotor.on) then it moves
     * the trucks to the standby position (standbackMotor.off then standbyMotor.on).
     * The motor is stopped after the temporisation has expired.
     * The command is completed when the position sensors at standby says the trucks are in standby.
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException
     */
    @Override
    public String goToStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError{
        
        
        checkPreConditionsForMotion();
        
        updateTrucksLocationWithSensors();
        
        if (this.isAtStandby()) {
            return getName() + "trucks already at standby position";
        }
        // to confort the position
        if (this.isAtStandback()) {
            
            sftTrucksMotor.moveToStandback();
            
            try {
                log.debug(getName() + ": Waiting for the position to be conforted");
                Thread.sleep(timeToConfortAPosition);
            } catch (InterruptedException ex) {
                log.error(ex);
            }
        }
        sftTrucksMotor.moveToStandby();
        setMovingToStandby(true);
        try {
            log.debug(getName() + ": Waiting for the trucks to go to STANDBY");
            Thread.sleep(timeToGoToStandby);
        } catch (InterruptedException ex) {
            log.error(ex);
        }
        this.sftTrucksMotor.off();
        setMovingToStandby(false);
        
        updateTrucksLocationWithSensors();

        if (this.isAtStandby()) {
            
            log.debug("====> " + getName() + "  IS AT STANDBY POSITION");            
            return getName() + " IS AT STANDBY POSITION";
        } else {
            throw new ErrorInCommandExecutionException(getName() + " could not go to STANDBY POSITION");
        }
 
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        if (isTrucksEmpty()) {
            throw new BadCommandException(getName() + "/moveFilterToStandback: Autochanger is empty");
        }
        goToStandback();
//        ((SimuFilterLatchModule) this.getLatchXminus()).donotDetectFilterPresence();
//        ((SimuFilterLatchModule) this.getLatchXplus()).donotDetectFilterPresence();
        this.updateLatchesStateWithSensors();
        publishDataAndNotifyObservers();
        return getName() + ": " + aFilter.getName() + " is at standback position.";
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        if (isTrucksEmpty()) {
            throw new BadCommandException(getName() + "/moveFilterToStandby: Autochanger is empty");
        }
        goToStandby();
//        ((SimuFilterLatchModule) this.getLatchXminus()).detectFilterPresence();
//        ((SimuFilterLatchModule) this.getLatchXplus()).detectFilterPresence();
        this.updateLatchesStateWithSensors();
        publishDataAndNotifyObservers();
        return getName() + ": " + aFilter.getName() + " is at standby position.";
    }

    @Override
    public String goToPosition(double trucksPositionOnline) throws BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getTrucksPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String moveFilterToOnline(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException, CanOpenError {
        return moveFilterToStandback(filter);
    }



    
    
    
    



}
