package org.lsst.ccs.subsystems.fcs.simulation;

import org.apache.log4j.Logger;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;
/**
 * This is the concrete state where we know what to be done when the engine is
 * in the state "Stop".
 * 
 * @author virieux
 * 
 */
public class StopState implements EngineState {
	
	protected static Logger log = Logger.getLogger("lsst.ccs.localbus");

	
	public double computeDisplacement(Motor engine, double period,
			RunningWay runningWay) {
		return 0;
	}

	public String error(Motor motor) {
		motor.setEngineState(ERROR);
		return motor.getName() + ": going in state " + this.toString();

	}

	
	public String go(Motor motor, double period, RunningWay runningWay) {
		motor.setStateChangeTime(System.currentTimeMillis());
		motor.setPeriod(period);		
		motor.setEngineState(RUNNING);
		String message = motor.getName() + ": starting...";
		log.info(message);
		return message;

	}

	public String stop(Motor motor) {
		return motor.getName() + ": is already stopped [StopState]";

	}

	@Override
	public String toString() {
		return "stop";
	}

}
