/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.util.Random;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;


/**
 * This class is to simulate a sensor which returns a value coded on 12bits.
 * It returns a random value between value1 and value2.
 * 
 * @author virieux
 */
public class SimuSensor14bits extends Sensor14bits {

    int value1 = this.getMinValue();
    int value2 = this.getMaxValue();
    Random randomGenerator = new Random();;
    
    //Default constructeur for Spring 
    public SimuSensor14bits() {}
    
    /**
     * Constructeur for a simulated sensor
     * TODO: the values cannot be greater than maxValue
     * @param aValue1
     * @param aValue2 
     */
    SimuSensor14bits(int aValue1, int aValue2) {
        super();
        this.value1 = aValue1;
        this.value2 = aValue2;
    }
    
    
    void setNewRange(int aValue1, int aValue2) {
        if ((aValue2 < aValue1) || (aValue2 > getMaxValue())) {
            String message = String.format("we must have : value1 < value2 < maxValue / value1= %s, value2=%s, maxValue=%s",value1,value2,getMaxValue());
            throw new IllegalArgumentException(message);
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    /**
     * 
     * @return a random between value1 and value2
     */
    public int readNewValue() {
        //System.out.println("value1= " + value1 + " value2= " + value2);
        int n = randomGenerator.nextInt(value2);  
        
        if (n > value1) {
            return n;
        } else {
            BigDecimal bd = new BigDecimal(value1 + n * (value2 - value1)/value2);           
            return bd.intValue();
        }
    }


}
