/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.AutoChangerTrucksLocation;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.NumericSensor;

/**
 * This class is used in the single filter test to simulate the rail sensors of the autochanger
 * and the filter presence sensor on the lachtes.
 * The simulated rail sensors listen to the motors and update their digitalValue when the motor are 
 * set on or off (cf SimuActuatorModule)
 * 
 * @author virieux
 */
public class SimuNumericSensor extends NumericSensor {
    
    CarouselModule carousel;
    Filter dummyFilter;
    
    
    
    //FOR SPRING
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    //FOR SPRING
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }
    
    public void initModule() {
        carousel = (CarouselModule) this.getModule("carousel");
        //dummyFilter = carousel.getFilterAtStandby();
        //this.dummyFilter = ((SftMainModule) this.getModule("main")).getDummyFilter();
    }
    
    

    public int readNewValue() {
        return this.digitalValue;
    }
    
    /**
     * What to do when a Module we observe updates its digitalValue :
     * we set a new digitalValue in the simulated sensor.
     * 
     * In the autochanger, the rail sensors at standback listens to the standbackMotor
     * and the rail sensors at standby listens to the standbyMotor (see description file)
     * 
     * The filter presence sensors in the latches listen to the simulated trucks.
     * TODO : the SimuCompactIOModule is going to listen to the standback and standby motors.
     */
    @Override
    public void processUpdate(Observable source, ValueUpdate v) {

            //if we observe a Motor
            // if the motor is ON, the new digitalValue is 1, if the motor is OFF the new digitalValue is 0.
            if (v.getName().contains("Motor")) {
                log.debug(getName() + "====> processUpdate from " + v.getName());
                if (v.getValue() instanceof Integer) { 
                        if ( ((Integer) v.getValue()).intValue() == 1) {
                            //this.setValue(1);
                        } else if ( ((Integer) v.getValue()).intValue() == 0){
                            //this.setValue(0);
                        }
                    
                }
                
            
            
            //if we observe the trucks of the autochanger
            } else if (v.getName().contains("truckX")) {
                log.debug(getName() + "====> processUpdate from " + v.getName());

               
                if (v.getValue() instanceof AutoChangerTrucksLocation) {
                        //in the simulation, if the filter is on carousel and trucks at standby, latch sensor "see" the filter.
                        if ( (((AutoChangerTrucksLocation) v.getValue()).equals(AutoChangerTrucksLocation.STANDBY) ) 
                            && (dummyFilter.isOnCarousel())) {
                            //this.setValue(1);
                        } else if ( ((AutoChangerTrucksLocation) v.getValue()).equals(AutoChangerTrucksLocation.UNKNOWN) ){
                            //this.setValue(0);
                        //in the simulation, if the filter is on carousel and trucks at standback, latch sensor "see" the filter.
                        } else if ( ((AutoChangerTrucksLocation) v.getValue()).equals(AutoChangerTrucksLocation.STANDBACK)
                                && (dummyFilter.isOnCarousel())) {
                                //this.setValue(0);                          
                        }
                    
                }
                
            }
            
    }


    @Override
    public void updateValue(String hexaValueReadOnDevice) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
