package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;

/**
 * A simulated latch for the carousel.
 * This latch is unlock when a filter
 * is being moved from standby position to on line position
 * by the auto-changer or vice versa.
 * 
 * @author virieux
 *
 */
public class SimuFilterLatchModule extends FilterLatchModule {
    
    

    
    @Override
    public void initModule() {
//            this.lockSensor.setValue(0);
//            this.unlockSensor.setValue(1);
//            this.filterPresenceSensor.setValue(0);
            setLockStatus(LockStatus.UNLOCKED);
    }

    @Override
    public synchronized String close() throws HardwareErrorDetectedException {
//        this.getLockSensor().setValue(1);
//        this.getUnlockSensor().setValue(0);
        try {
            return super.close();
        } catch (BadCommandException ex) {
            Logger.getLogger(SimuFilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ErrorInCommandExecutionException ex) {
            Logger.getLogger(SimuFilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public synchronized String open() throws HardwareErrorDetectedException {
//        this.getLockSensor().setValue(0);
//        this.getUnlockSensor().setValue(1);
        try {
            return super.open();
        } catch (BadCommandException ex) {
            Logger.getLogger(SimuFilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ErrorInCommandExecutionException ex) {
            Logger.getLogger(SimuFilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;

    }
   
	



}
