/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.AutoChangerTrucksLocation;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;

/**
 * A very basic simulated filter clamp module.
 * It has no sensor to know if the clamp is locked or not.
 * This clamp is locked when the clamps actuator of the carousel are off.
 * And its filter presence sensor is configured to returns the value we expect!
 * 
 * @author virieux
 */
public abstract class SimuFilterClampModule extends FilterClampModule {

    /*
     * AutoChanger trucks position limit to know if a filter is
     * on carousel or not.
     */
    //private double trucksPositionLimit;

    //private boolean atStandby;
    
    protected CarouselModule carousel;
    protected Filter dummyFilter;
        //TODO just for tests (cf tick method). 
    private BasicAutoChangerModule autochanger;

    //FOR SPRING
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    //FOR SPRING
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }
    




    public abstract boolean isLocked();
    @Override
    public double readTemperature() {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    @Override
    public void initModule() {
        this.carousel = (CarouselModule) this.getModule("carousel");
        this.autochanger = (BasicAutoChangerModule) this.getModule("autochanger");
        
        this.filterPresenceStatus = FilterPresenceStatus.ENGAGED;

        this.clampState = FilterClampState.CLAMPEDONFILTER;
        ((SimuSensor14bits) getFilterPresenceSensor()).setNewRange(getFilterPositionValueA(), getFilterPositionValueB());
        //trucksPositionLimit = 5;
        //setAtStandby(false);
        //simu clamp is LOCKED
        //((SimuSensor14bits) getLockSensor()).setNewRange(this.getLockSensorValueB(),this.getLockSensorValueC());        
        this.setLockStatus(LockStatus.LOCKED);
    }

    /**
    * What to do when the Modules we observe send there new values.
    * A Simulated clamp Module observes the autochanger truks.
    *
    */
    @Override
    public void processUpdate(Observable source, ValueUpdate v) {
        
        
        log.debug(getName() + "====> processUpdate from " + v.getName());
//        log.debug("#####" + "AUTOCHANGER IS EMPTY=" + autochanger.isTrucksEmpty());
//        log.debug("#####" + "AUTOCHANGER IS AT STANDBY=" + autochanger.isAtStandby());
        SimuSensor14bits sensor = (SimuSensor14bits) getFilterPresenceSensor();
        
        if (v.getValue() instanceof AutoChangerTrucksLocation) {
                //in the simulation, if the filter is on carousel and trucks at standby, clamp "sees" the filter.
                if ( (((AutoChangerTrucksLocation) v.getValue()).equals(AutoChangerTrucksLocation.STANDBY) ) 
                    && (dummyFilter.isOnAutoChanger())) {
                    //in the simulated software of the single filter test 
                    //there is always a filter either in carousel either in autochanger
                    //if autochanger is at Standby, the filter is at standby position too
                    sensor.setNewRange(getFilterPositionValueA(), getFilterPositionValueB());
                } else if ( ((AutoChangerTrucksLocation) v.getValue()).equals(AutoChangerTrucksLocation.UNKNOWN) ){
                    sensor.setNewRange(getFilterPositionValueC(), sensor.getMaxValue());
                //in the simulation, if the filter is on carousel and trucks at standback, the clamp does not "see" the filter.
                } else if ( ((AutoChangerTrucksLocation) v.getValue()).equals(AutoChangerTrucksLocation.STANDBACK)
                        && (dummyFilter.isOnAutoChanger())) {
                        sensor.setNewRange(getFilterPositionValueC(), sensor.getMaxValue());                          
                }

        }
        
       updateStateWithSensors();

       log.debug(getName() + " : filterPresence =" + filterPresenceStatus.toString());
       StatusDataPublishedByClamp status = this.getStatusData();
       sendToStatus(status);
       setChanged();
       notifyObservers(new ValueUpdate(publishedByClampOutputName,status));
    }
    
}
