/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Random;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;

/**
 *
 * @author virieux
 */
public class SimuClampActuatorModule extends ClampActuatorModule {

    Random r = new Random();

    @Override
    public void initModule() {
        this.on = false;
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        on = true;
//        this.sentValue = 500;
        this.sendToStatus(this.getStatusData());
        return getName() + " is turned ON.";
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        on = false;
        this.sentValue = 0;
        this.sendToStatus(this.getStatusData());
        return getName() + " is turned OFF.";
    }

    public int getSentValue() {
//        if (isOn()) {
            if (getSentCurrentMinValue() >= 0) {
                return r.nextInt(getSentCurrentMaxValue());
            }
            return (int) (r.nextGaussian()) * getSentCurrentMaxValue() / 2;
//        }
//        return 0;
    }

    @Override
    public void tick() {
        this.sendToStatus(this.getStatusData());
    }

    
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getName());
        if (isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }

    @Override
    public int getMotor_continuousCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_maxSpeedInCurrentMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMotor_mode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_outputCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_polePairNumber() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_thermalTimeConstantWinding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_type() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNodeID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPositionSensorType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSerialNB() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String maintainCurrent() throws BadCommandException, ErrorInCommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
