/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

/**
 * This exception is thrown when we can't detect a given Serial Number
 * on the Can Open network.
 * @author virieux
 */
public class HardwareNotDetectedException extends Exception {
    PieceOfHardware pieceOfHardware;
    /**
     * Creates a new instance of <code>HardwareNotDetectedException</code> without detail message.
     */
    public HardwareNotDetectedException() {
        super();
    }

    /**
     * Constructs an instance of <code>HardwareNotDetectedException</code> with the specified detail message.
     * @param msg the detail message.
     */
    public HardwareNotDetectedException(String msg) {
        super(msg);
    }
    
    public HardwareNotDetectedException(PieceOfHardware aPieceOfHardware) {
        super();
        this.pieceOfHardware = aPieceOfHardware;
    }
    
    public HardwareNotDetectedException(PieceOfHardware aPieceOfHardware, String msg) {
        super(msg);
        this.pieceOfHardware = aPieceOfHardware;
        
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(pieceOfHardware.getName());
        sb.append(" serial NB=");
        sb.append(pieceOfHardware.getSerialNB());
        sb.append(" has not been detected.");
        return sb.toString();
    }
}
