/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;

/**
 * This exception is thrown when the detected node ID of a piece of hardware
 * doesn't match the node ID that is in the configuration DB.
 * @author virieux
 */
public class ConfigNodeIDMismatchException extends Exception {
    CanOpenNode node;
    PieceOfHardware pieceOfHardware;

    /**
    * Constructs an instance of <code>ConfigNodeIDMismatchException</code> with the specified detail message.
    * @param msg the detail message.
    */

    
    public ConfigNodeIDMismatchException(CanOpenNode aNode, PieceOfHardware aPieceOfHardware) {
        super();
        this.node = aNode;
        this.pieceOfHardware = aPieceOfHardware;          
    }
    
    public ConfigNodeIDMismatchException(CanOpenNode aNode, PieceOfHardware aPieceOfHardware, String msg) {
        super(msg);
        this.node = aNode;
        this.pieceOfHardware = aPieceOfHardware;          
    }
    
    public ConfigNodeIDMismatchException(String cause, CanOpenNode aNode, PieceOfHardware aPieceOfHardware) {
        super(cause);
        this.node = aNode;
        this.pieceOfHardware = aPieceOfHardware;
    }


    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Hardware name=");
        sb.append(pieceOfHardware.getName());
        sb.append(" serial NB=");
        sb.append(pieceOfHardware.getSerialNB());
        sb.append(" expected nodeID=");
        sb.append(pieceOfHardware.getNodeID());
        sb.append(" detected nodeID=");
        sb.append(this.node.getNodeID());
        return sb.toString();           
    }
}
