/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * Throwned when we received an emergency message for a node.
 * @author virieux
 */
public class CanOpenError extends Exception {
    
    /**
     * Node ID of the node in error in hexa.
     */
    String nodeID;
    String errCode;
    


    /**
     * Creates a new instance of <code>CanOpenError</code> without detail message.
     */
    public CanOpenError() {
    }

    /**
     * Constructs an instance of <code>CanOpenError</code> with the specified detail message.
     * @param msg the detail message.
     */
    public CanOpenError(String msg) {
        super(msg);
    }
    
    public CanOpenError(String msg, String nodeID, String errCode) {
        super(msg);
        this.nodeID = nodeID;
        this.errCode = errCode;
    }
    
    public void setErrCode(String errCode) {
        this.errCode = errCode;
        
    }
}
