/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

/**
 * This is a Model for a sensor on a can open bus which communicates over Can Open protocol.
 * The sensor is supposed to be connected to a ADC with analogics input.(CAN-CBX-AI814)
 * @author virieux
 */
public class CanOpenSensor14bits extends Sensor14bits {
    
     /**
     * The ADC on which this sensor is plugged.
     */
    CanOpenADC adc;
    
    /**
     * The numero of analog input where the sensor is plugged.
     */
    int numOfAnalogInput;
    

  
    
    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/
    
    
    public CanOpenADC getAdc() {
        return adc;
    }

    public void setAdc(CanOpenADC adc) {
        this.adc = adc;
    }

    public int getNumOfAnalogInput() {
        return numOfAnalogInput;
    }

    public void setNumOfAnalogInput(int numOfAnalogInput) {
        this.numOfAnalogInput = numOfAnalogInput;
    }
    
    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/

    @Override
    public int readNewValue() {
        try {
            String valueInHexa = adc.readAnalogInput(numOfAnalogInput);
            
            value = Integer.parseInt(valueInHexa, 16);
            return value;
            
        } catch (SDORequestError ex) {
            log.error(getName() + " CanOpen Error in reading sensor " + ex.getMessage());
            this.getSubsystem().updateState(State.InError,getName() + " CanOpen Error in reading sensor:" + ex.getMessage());
        } catch (HardwareNotDetectedException ex) {
            log.error(ex);
            this.getSubsystem().updateState(State.InError, getName() 
                          +  " not booted or error in config." + ex.getMessage());
        }
        return 0;
    }





}
