/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.NumericSensor;

/**
 *
 * @author virieux
 */
public class CanOpenNumericSensor extends NumericSensor {
    
    CanOpenDIO dio;
    int inputNumero;

    public CanOpenDIO getDio() {
        return dio;
    }

    public void setDio(CanOpenDIO dio) {
        this.dio = dio;
    }

    public int getInputNumero() {
        return inputNumero;
    }

    public void setInputNumero(int inputNumero) {
        this.inputNumero = inputNumero;
    }

    /**
     * This methods updates the digital value for this sensor.
     * It takes as an argument the value in hexa sent by the CompactIOModule.
     * This hexa value represents the 8 values for the 8 channels.
     * To retrieve the value for this sensor, the hexa value is transformed in binary, 
     * then reverse and the digital value is the digit at the index= inputNumero.
     * exmaple if hex = 80, and inputNumero=8, digital value=1 otherwise digital value=0.
     * @param hex 
     */
    @Override
    public synchronized void updateValue(String hex) {
        log.debug(Thread.currentThread().toString());
        log.debug(getName() + " INPUT NO=" + inputNumero);
        
        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
        
        //to add leading zeros on the left
        String s = String.format("%08d", Integer.parseInt(bin));
        log.debug("binary value=" + s);
        
        //to retrieve the digital value for this sensor
        //(the digits are given from left to right
        //1010000 => DIO[8]=1,DIO[7]=0,DIO[6]=1,DIO[5]=0,DIO[4]=0,DIO[3]=0,DIO[2]=0,DIO[1]=0
        int myValue = Character.digit(s.charAt(8-inputNumero), 16);
        log.debug(getName() + " Value updated=" + myValue);

        this.digitalValue = myValue;
    }





    
    
    
}
