/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCError;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

/**
 * This is a Filter Clamp Module that is drived by a Can Open bus.
 * @author virieux
 */
public class CanOpenFilterClampModule extends FilterClampModule {
    
    /**
     * The ADC which controls the clamp temperature.
     */
    CanOpenADC adc;
    
    /**
     * The numero of analog input of the ADC on which a thermometer is plugged.
     */
    int numOfAnalogInputForTemp;

    public CanOpenADC getAdc() {
        return adc;
    }

    public void setAdc(CanOpenADC adc) {
        this.adc = adc;
    }


    public int getNumOfAnalogInputForTemp() {
        return numOfAnalogInputForTemp;
    }

    public void setNumOfAnalogInputForTemp(int numOfAnalogInputForTemp) {
        this.numOfAnalogInputForTemp = numOfAnalogInputForTemp;
    }


    
    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/

    
     /**
     * Read the temperature, for each clamp, 
     * a thermometer is plugged on the input number numOfAnalogInputForTemp
     * of the ADC AI814.
     * @return 
     * @throws ReadingADCError 
     */
    @Override
    public double readTemperature()  {
        double temp = 0;
        try {

            String valueInHexa = adc.readAnalogInput(numOfAnalogInputForTemp);
            log.debug("Value in HEXA=" + valueInHexa);
            int value = Integer.parseInt(valueInHexa, 16);
            double voltage = value * CanOpenADC.adcVoltsPerBit;
            log.debug("Input Value read on the ADC:" + value);
            log.debug("Voltage = " + voltage + " volts");
            temp = (voltage / 10) - CanOpenADC.waterFreezeTemp;
            return temp;
        } catch (HardwareNotDetectedException ex) {
                log.error(ex);
                this.getSubsystem().updateState(State.InError, getName() 
                          +  " not booted or error in config.");
        } catch (SDORequestError ex) {
            log.error(getName() + " CanOpen Error in reading temperature " + ex.getMessage());
            this.getSubsystem().updateState(State.InError,getName() + " CanOpen Error in reading temperature.");
        }
        return temp;
        
    }

    
    
}
