package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.CyclicBarrier;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * This is a model for the Latch which holds a filter on an autochanger's truck.
 * There is 2 trucks on the autochanger, so there is 2 latches : LatchX- and LatchX+
 * @author virieux
 */
public interface FilterLatch {

    
	public String unlock() throws BadCommandException, ErrorInCommandExecutionException;
	
	public String lock() throws BadCommandException, ErrorInCommandExecutionException;;

	public boolean isLocked();
        
        public boolean isUnlocked();
        
        public boolean isInError();
        
        public boolean isFilterEngaged();
        
        public LockStatus getLockStatus();
        
       

}
