/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.framework.Module;

/**
 * This class represents a numeric sensor which sends a digitalValue 0 or 1.
 * This type of sensors are used in the autochanger for the rail filter presence sensor :
 * the sensors which detects if a filter is there or not on each side of the rail and at 
 * standby and standback position.
 * This is used too to monitor the autochanger latches : to know if a latch is locked or unlocked. 
 * @author virieux
 */
public abstract class NumericSensor extends Module {
    
    public int digitalValue = 0;
    
    @Override
    public void initModule() {
        this.digitalValue = 0;
    }

    public void setDigitalValue(int digitalValue) {
        this.digitalValue = digitalValue;
    }


    public int getDigitalValue() {
        log.debug(getName() + " GET DIGITAL VALUE= " + this.digitalValue);
        return this.digitalValue;
    }
    

    /**
     * update the digitalValue of this object with the 
     * @param channels 
     */
    public  abstract  void updateValue(String hexaValueReadOnDevice);
    
}
