/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;

public class SftCarouselModule
extends CarouselModule {
    @Override
    public CarouselSocket getSocketAtStandby() {
        return this.getSockets()[0];
    }

    @Override
    public double getPosition() {
        return 0.0;
    }

    public void updateStateWithSensors() throws HardwareError, BadCommandException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException("Unable to read sensors when there is no socket at standby.");
        }
        this.getSocketAtStandby().updateClampsStateWithSensors();
        Filter dummyFilter = ((SftMainModule)this.getModule("main")).getDummyFilter();
        if (this.getSocketAtStandby().isClampedOnFilter() || this.getSocketAtStandby().isUnclampedOnFilter()) {
            this.getSocketAtStandby().putFilterOnSocket(dummyFilter);
        } else {
            this.getSocketAtStandby().removeFilter();
        }
    }

    @Override
    public boolean isAbleToMove() {
        return false;
    }

    @Override
    public boolean isRotating() {
        return false;
    }

    @Override
    public String rotate(double angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }

    @Override
    public String stop() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

    @Override
    public String lock() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

    @Override
    public String unlock() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }
}

