/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.util.Random;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;

public class SimuSensor14bits
extends Sensor14bits {
    int value1 = this.getMinValue();
    int value2 = this.getMaxValue();
    Random randomGenerator = new Random();

    public SimuSensor14bits() {
    }

    SimuSensor14bits(int aValue1, int aValue2) {
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    void setNewRange(int aValue1, int aValue2) {
        if (aValue2 < aValue1 || aValue2 > this.getMaxValue()) {
            String message = String.format("we must have : value1 < value2 < maxValue / value1= %s, value2=%s, maxValue=%s", this.value1, this.value2, this.getMaxValue());
            throw new IllegalArgumentException(message);
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    @Override
    public int readNewValue() {
        int n = this.randomGenerator.nextInt(this.value2);
        if (n > this.value1) {
            return n;
        }
        BigDecimal bd = new BigDecimal(this.value1 + n * (this.value2 - this.value1) / this.value2);
        return bd.intValue();
    }
}

