/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.errors;

import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.errors.HardwareConfigurationError;

public class NodeIDMismatchException
extends HardwareConfigurationError {
    CanOpenNode node;
    PieceOfHardware pieceOfHardware;

    public NodeIDMismatchException(CanOpenNode aNode, PieceOfHardware aPieceOfHardware) {
        this.node = aNode;
        this.pieceOfHardware = aPieceOfHardware;
    }

    public NodeIDMismatchException(String msg, CanOpenNode aNode, PieceOfHardware aPieceOfHardware) {
        super(msg);
        this.hardwareName = aPieceOfHardware.getName();
        this.node = aNode;
        this.pieceOfHardware = aPieceOfHardware;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("A piece of hardware has been detected by its serial number, but with a different node ID than in the configuration.");
        sb.append(this.hardwareName);
        sb.append(" serial NB=");
        sb.append(this.pieceOfHardware.getSerialNB());
        sb.append(" expected nodeID=");
        sb.append(this.pieceOfHardware.getNodeID());
        sb.append(" detected nodeID=");
        sb.append(this.node.getNodeID());
        return sb.toString();
    }
}

