/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;

public class CanOpenThermometer
extends CanOpenSensor14bits
implements Thermometer {
    @Override
    public double readTemperature() throws HardwareError {
        double temp = 0.0;
        String valueInHexa = this.adc.readAnalogInput(this.numOfAnalogInput);
        Module.log.debug((Object)("Value in HEXA=" + valueInHexa));
        int valueInt = Integer.parseInt(valueInHexa, 16);
        double voltage = (double)valueInt * 0.3125;
        Module.log.debug((Object)("Input Value read on the ADC:" + valueInt));
        Module.log.debug((Object)("Voltage = " + voltage + " volts"));
        temp = voltage / 10.0 - 273.15;
        return temp;
    }
}

