/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.FcsAlarm;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCommunicationError;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenDeviceError;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenGenericError;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenMotionError;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenTemperatureError;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenVoltageError;
import org.lsst.ccs.subsystems.fcs.errors.ErrorInBootingHardwareProcess;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.NodeIDMismatchException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;
import org.lsst.ccs.subsystems.fcs.errors.UnexpectedBootMessageReceived;

public class CanOpenProxy
extends FcsTcpProxy {
    private String myClientName = "CanOpenProxy";
    private int expectedNodesNB;
    private int bootedNodesNB = 0;
    private CanOpenNode[] nodes = new CanOpenNode[this.getExpectedNodesNB()];
    private boolean hardwareBootProcessEnded = false;
    private boolean hardwareIdentified = false;
    private long hardwareBootTimeout = 2000L;
    private long hardwareBootProcessBeginTime;
    public PieceOfHardware[] hardwareList;
    private boolean canOpenNodeNumbersOK = false;
    private boolean canOpenNodesChecked = false;

    public int getExpectedNodesNB() {
        return this.expectedNodesNB;
    }

    public void setExpectedNodesNB(int nodeNB) {
        this.expectedNodesNB = nodeNB;
    }

    public int getBootedNodesNB() {
        return this.bootedNodesNB;
    }

    public String getMyClientName() {
        return this.myClientName;
    }

    public void setMyClientName(String myClientName) {
        this.myClientName = myClientName;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.nodes = new CanOpenNode[this.getExpectedNodesNB()];
        this.hardwareBootProcessBeginTime = 0L;
    }

    public boolean isHardwareIdentified() {
        return this.hardwareIdentified;
    }

    public void tick() {
        if (this.hardwareBootProcessBeginTime == 0L && this.isReady(this.myClientName)) {
            this.hardwareBootProcessBeginTime = System.currentTimeMillis();
        }
        if (this.hardwareBootProcessBeginTime > 0L && !this.hardwareBootProcessEnded) {
            long hardwareBootDuration = System.currentTimeMillis() - this.hardwareBootProcessBeginTime;
            if (this.bootedNodesNB == this.getExpectedNodesNB()) {
                this.hardwareBootProcessEnded = true;
            } else if (hardwareBootDuration > this.hardwareBootTimeout) {
                this.hardwareBootProcessEnded = true;
                Module.log.error((Object)"Timeout expired during hardware booting process ");
                this.getSubsystem().updateState(State.InError, "Timeout expired during hardware booting process : number of booted is not was expected");
            }
        }
        if (this.hardwareBootProcessEnded && !this.hardwareIdentified) {
            try {
                this.identifieHardware();
            }
            catch (TimeoutException ex) {
                Module.log.error((Object)"Timeout expired during hardware identifie process ");
                this.getSubsystem().updateState(State.InError, "Timeout expired during hardware identifie process." + ex.getMessage());
            }
            this.hardwareIdentified = true;
        }
        if (this.hardwareIdentified && !this.canOpenNodesChecked) {
            try {
                this.canOpenNodesChecked = this.checkCanOpenNodes();
                Module.log.debug((Object)"Hardware configuration is checked");
            }
            catch (NodeIDMismatchException ex) {
                this.canOpenNodesChecked = false;
                Module.log.error((Object)("ERROR in configuration for a nodeID" + ex.getMessage()));
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
            catch (HardwareNotDetectedException ex) {
                this.canOpenNodesChecked = false;
                Module.log.error((Object)("HARDWARE NOT DETECTED : POWER FAILURE ?" + ex.getMessage()));
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
            catch (ErrorInBootingHardwareProcess ex) {
                this.canOpenNodesChecked = false;
                Module.log.error((Object)("HARDWARE NOT DETECTED : POWER FAILURE ?" + ex.getMessage()));
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
            catch (BadCommandException ex) {
                Module.log.error((Object)ex.getMessage());
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
        }
    }

    public boolean isBooted(String aNodeID) {
        if (this.bootedNodesNB == 0) {
            return false;
        }
        boolean nodeFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(aNodeID)) {
                nodeFound = true;
            }
            ++i;
        }
        return nodeFound;
    }

    public boolean isBooted(PieceOfHardware piece) {
        if (this.bootedNodesNB == 0) {
            return false;
        }
        boolean pieceFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(piece.getNodeID())) {
                pieceFound = true;
            }
            ++i;
        }
        return pieceFound;
    }

    public boolean isConfigOK(PieceOfHardware piece) {
        if (this.bootedNodesNB == 0) {
            return false;
        }
        boolean pieceFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(piece.getNodeID()) && this.nodes[i].getSerialNB().equals(piece.getSerialNB())) {
                pieceFound = true;
            }
            ++i;
        }
        return pieceFound;
    }

    public String listNodes() {
        StringBuilder sb = new StringBuilder("Nodes LIST = (values are in HEXA)");
        int i = 0;
        while (i < this.bootedNodesNB) {
            sb.append("\n");
            if (this.nodes[i] == null) {
                sb.append("null node");
            } else {
                sb.append(this.nodes[i].toString());
            }
            ++i;
        }
        return sb.toString();
    }

    public String sendCanOpen(String command) throws TimeoutException {
        String[] words = command.split(",");
        String keyWord = words[0];
        if (words.length > 1 ? !keyWord.equals("rsdo") && !keyWord.equals("wsdo") && !keyWord.equals("info") && !keyWord.equals("rsync") && !keyWord.equals("srtr") : !keyWord.equals("sync") && !keyWord.equals("rpdo") && !keyWord.equals("quit")) {
            throw new IllegalArgumentException(command);
        }
        return (String)this.call(this.getMyClientName(), command);
    }

    private static String buildWsdoCommand(String nodeID, String index, String subindex, String size, String data) {
        char sep = ',';
        String command = String.format("wsdo%1$s%2$s%1$s%3$s%1$s%4$s%1$s%5$s%1$s%6$s", Character.valueOf(sep), nodeID, index, subindex, size, data);
        System.out.println("Command built = " + command);
        return command;
    }

    private static String buildRsdoCommand(String nodeID, String index, String subindex) {
        char sep = ',';
        String command = String.format("rsdo%1$s%2$s%1$s%3$s%1$s%4$s", Character.valueOf(sep), nodeID, index, subindex);
        return command;
    }

    public String writeSDO(String nodeID, String index, String subindex, String size, String value) throws SDORequestError {
        String errorCode;
        String sdoResponseLine;
        block4: {
            try {
                sdoResponseLine = this.sendCanOpen(CanOpenProxy.buildWsdoCommand(nodeID, index, subindex, size, value));
                String[] words = sdoResponseLine.split(",");
                String cfr_ignored_0 = words[0];
                String cfr_ignored_1 = words[1];
                errorCode = words[2];
                if (!errorCode.equals("0")) break block4;
                return "writeSDO request OK";
            }
            catch (TimeoutException ex) {
                SDORequestError err = new SDORequestError("write SDO request timeout expired : ", nodeID, "timeout expired", index, subindex, ex.getMessage());
                Module.log.error((Object)String.format("%s %s is %s stopped ?", "SDO request timeout expired : ", ex.getMessage(), nodeID));
                throw err;
            }
        }
        if (errorCode.equals("-1")) {
            Module.log.error((Object)("Wrong SDO command : " + sdoResponseLine));
            throw new SDORequestError("Wrong SDO command : " + sdoResponseLine);
        }
        Module.log.error((Object)"SDO request was going wrong");
        String error = String.format("%08d", Integer.parseInt(errorCode));
        Module.log.debug((Object)("ERROR=" + error));
        String errorName = CanOpenErrorsTable.commErrorCodes.getProperty(error);
        throw new SDORequestError("SDO request was going wrong", errorCode, nodeID, index, subindex, errorName);
    }

    public String writeSDO(int nodeID, String index, String subindex, int size, int value) throws SDORequestError {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        return this.writeSDO(Integer.toHexString(nodeID), index, subindex, Integer.toHexString(size), Integer.toHexString(value));
    }

    public String readSDO(String nodeID, String index, String subindex) throws SDORequestError {
        try {
            String sdoLine = this.sendCanOpen(CanOpenProxy.buildRsdoCommand(nodeID, index, subindex));
            String[] words = sdoLine.split(",");
            int cfr_ignored_0 = words.length;
            String cfr_ignored_1 = words[0];
            String cfr_ignored_2 = words[1];
            String errorCode = words[2];
            if (errorCode.equals("0") && words.length > 3) {
                return words[3];
            }
            if (errorCode.equals("-1")) {
                Module.log.error((Object)("Wrong SDO command : " + sdoLine));
                throw new SDORequestError("Wrong SDO command : " + sdoLine);
            }
            Module.log.error((Object)("SDO request was going wrong, received response=" + sdoLine));
            String error = String.format("%08d", Integer.parseInt(errorCode));
            Module.log.debug((Object)("ERROR=" + error));
            String errorName = CanOpenErrorsTable.commErrorCodes.getProperty(error);
            throw new SDORequestError("SDO request was going wrong", nodeID, errorCode, index, subindex, errorName);
        }
        catch (TimeoutException ex) {
            SDORequestError err = new SDORequestError("read SDO request timeout expired : ", nodeID, "timeout expired", index, subindex, ex.getMessage());
            Module.log.error((Object)String.format("%s %s is %s stopped ?", "SDO request timeout expired : ", ex.getMessage(), nodeID));
            throw err;
        }
    }

    public String readSDO(int nodeID, String index, String subindex) throws SDORequestError {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        return this.readSDO(Integer.toHexString(nodeID), index, subindex);
    }

    public void identifieHardware() throws TimeoutException {
        Module.log.debug((Object)"Identification of the hardware");
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null) {
                Module.log.debug((Object)("Sending to can open command : info," + this.nodes[i].getNodeID()));
                String result = this.sendCanOpen("info," + this.nodes[i].getNodeID());
                Module.log.debug((Object)("Received on socket command = " + result));
                String infoLine = result;
                String[] words = infoLine.split(",");
                String command = words[0];
                String nodeID = words[1];
                if (command.equals("info") && nodeID.equals(this.nodes[i].getNodeID())) {
                    Module.log.debug((Object)("updating Node Info for node " + nodeID));
                    String type = words[2];
                    String vendor = words[3];
                    String productCode = words[4];
                    String revision = words[5];
                    String serialNB = words[6];
                    this.nodes[i].setNodeInfo(type, vendor, productCode, revision, serialNB);
                } else {
                    Module.log.debug((Object)("ERROR for command = " + command + "NodeID = " + nodeID));
                }
            }
            ++i;
        }
        Module.log.debug((Object)"Hardware is identified");
        Module.log.debug((Object)this.listNodes());
    }

    public boolean isHardwareReady() {
        Module.log.debug((Object)("hardwareBootProcessEnded=" + this.hardwareBootProcessEnded));
        Module.log.debug((Object)("hardwareIdentified=" + this.hardwareIdentified));
        Module.log.debug((Object)("canOpenNodeNumbersOK=" + this.canOpenNodeNumbersOK));
        Module.log.debug((Object)("canOpenNodesChecked=" + this.canOpenNodesChecked));
        return this.hardwareBootProcessEnded && this.hardwareIdentified && this.canOpenNodeNumbersOK && this.canOpenNodesChecked;
    }

    public CanOpenNode getDetectedNodeForSerialNumber(String aSerialNB) {
        CanOpenNode detectedNode = null;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i].getSerialNB().equals(aSerialNB)) {
                detectedNode = this.nodes[i];
            }
            ++i;
        }
        return detectedNode;
    }

    @Override
    void processBootMessage(String nodeID) {
        if (this.isBooted(nodeID)) {
            if (this.hardwareBootProcessEnded) {
                String msg = "An asynchronus boot message is arrived for node ID = " + nodeID;
                Module.log.error((Object)msg);
                UnexpectedBootMessageReceived ex = new UnexpectedBootMessageReceived(msg, nodeID);
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
        } else {
            this.nodes[this.bootedNodesNB] = new CanOpenNode(nodeID);
            ++this.bootedNodesNB;
            Module.log.debug((Object)("Node " + nodeID + " added"));
            Module.log.debug((Object)("Hardware booted nb=" + this.bootedNodesNB));
        }
    }

    @Override
    void processEmcyMessage(String message) {
        String[] words = message.split(",");
        String nodeID = words[1];
        String cfr_ignored_0 = words[2];
        String errReg = words[3];
        Module.log.error((Object)("Received EMERGENCY message for nodeID: " + nodeID));
        Module.log.error((Object)("message=" + message));
        String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errReg);
        Module.log.debug((Object)("errorName=" + errorName));
        try {
            if (errReg.equals("01")) {
                throw new CanOpenGenericError(errorName, nodeID, errReg);
            }
            if (errReg.equals("04")) {
                throw new CanOpenVoltageError(errorName, nodeID, errReg);
            }
            if (errReg.equals("08")) {
                throw new CanOpenTemperatureError(errorName, nodeID, errReg);
            }
            if (errReg.equals("10")) {
                throw new CanOpenCommunicationError(errorName, nodeID, errReg);
            }
            if (errReg.equals("20")) {
                throw new CanOpenDeviceError(errorName, nodeID, errReg);
            }
            if (errReg.equals("80")) {
                throw new CanOpenMotionError(errorName, nodeID, errReg);
            }
            throw new CanOpenError("Received EMERGENCY message (UNKNOWN Cnn Open Error) for nodeID: " + nodeID);
        }
        catch (CanOpenError ex) {
            Module.log.error((Object)ex.getMessage());
            FcsAlarm alarm = new FcsAlarm(ex.toString());
            this.sendToStatus((Status)alarm);
            String.format("NodeID %s (%02d in decimal) : %s ", nodeID, Integer.parseInt(nodeID, 16), ex.getMessage());
            return;
        }
    }

    @Override
    void processUnknownCommand(String message) {
        String[] words = message.split(",");
        String command = words[1];
        String errorMessage = "Unknown command:" + command;
        Module.log.error((Object)errorMessage);
    }

    public boolean checkCanOpenNodes() throws BadCommandException, ErrorInBootingHardwareProcess, NodeIDMismatchException, HardwareNotDetectedException {
        if (!this.isReady(this.myClientName) || !this.isHardwareIdentified()) {
            throw new BadCommandException("Hardware not booted or not identified");
        }
        Module.log.debug((Object)"CHECKING HARDWARE CONFIGURATION ");
        if (this.bootedNodesNB == 0) {
            Module.log.error((Object)"NO HARDWARE DETECTED : POWER FAILURE ?");
            throw new ErrorInBootingHardwareProcess("NO HARDWARE DETECTED : POWER FAILURE ?", this.hardwareBootTimeout, this.bootedNodesNB, this.expectedNodesNB);
        }
        if (this.bootedNodesNB != this.expectedNodesNB) {
            Module.log.error((Object)"SOME HARDWARE IS MISSING : POWER FAILURE ?");
            throw new ErrorInBootingHardwareProcess("SOME HARDWARE IS MISSING : POWER FAILURE ?", this.hardwareBootTimeout, this.bootedNodesNB, this.expectedNodesNB);
        }
        this.canOpenNodeNumbersOK = true;
        boolean configNodesID = true;
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware hardware = pieceOfHardwareArray[n2];
            Module.log.debug((Object)("ABOUT TO CHECK: " + hardware.getName() + " NODE_ID=" + hardware.getNodeID()));
            boolean configOK = this.checkCanOpenNodeConfiguration(hardware);
            configNodesID = configNodesID && configOK;
            Module.log.info((Object)(String.valueOf(hardware.getName()) + " CONFIG OK=" + configOK));
            ++n2;
        }
        return configNodesID;
    }

    public boolean checkCanOpenNodeConfiguration(PieceOfHardware pieceOfHardware) throws BadCommandException, NodeIDMismatchException, HardwareNotDetectedException {
        String detectedNodeID;
        if (!this.hardwareBootProcessEnded || !this.hardwareIdentified) {
            throw new BadCommandException("Hardware not booted or not identified");
        }
        Module.log.debug((Object)("Checking configuration for " + pieceOfHardware.getName()));
        CanOpenNode canOpenNode = this.getDetectedNodeForSerialNumber(pieceOfHardware.getSerialNB());
        if (this.isBooted(pieceOfHardware)) {
            detectedNodeID = canOpenNode.getNodeID();
            if (!detectedNodeID.equals(pieceOfHardware.getNodeID())) {
                throw new NodeIDMismatchException("ERROR IN CAN OPEN NODE ID CONFIGURATION", canOpenNode, pieceOfHardware);
            }
        } else {
            throw new HardwareNotDetectedException("HARDWARE NOT DETECTED", pieceOfHardware.getName(), pieceOfHardware.getNodeID(), pieceOfHardware.getSerialNB());
        }
        Module.log.debug((Object)(String.valueOf(pieceOfHardware.getName()) + " Serial Number= " + pieceOfHardware.getSerialNB() + " is node ID=" + detectedNodeID));
        return pieceOfHardware.isConfigOK();
    }

    public String listHardware() {
        StringBuilder sb = new StringBuilder();
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware pieceOfHardware = pieceOfHardwareArray[n2];
            sb.append(pieceOfHardware.toString());
            sb.append("**");
            ++n2;
        }
        return sb.toString();
    }

    public void initializeHardware() {
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware pieceOfHardware = pieceOfHardwareArray[n2];
            pieceOfHardware.initialize();
            ++n2;
        }
    }

    public String configAsHeartbeatProducer(String nodeID, String heartbeat_time) throws SDORequestError, TimeoutException {
        return this.writeSDO(nodeID, "1017", "0", "2", heartbeat_time);
    }

    public String configAsHeartbeatProducer(int nodeID, int heartbeat_time) throws SDORequestError, TimeoutException {
        if (heartbeat_time < 0 || heartbeat_time > 65025) {
            throw new IllegalArgumentException("heartbeat_time is coded on 2 bytes can't be > 65535");
        }
        return this.configAsHeartbeatProducer(Integer.toHexString(nodeID), Integer.toHexString(heartbeat_time));
    }

    public String configAsHeartbeatConsumer(int nodeID, int producerNodeID, int heartbeat_time) throws SDORequestError, TimeoutException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        if (producerNodeID < 0 || producerNodeID > 127) {
            throw new IllegalArgumentException("producerNodeID must be > 0 and < 128");
        }
        if (heartbeat_time < 0 || heartbeat_time > 65025) {
            throw new IllegalArgumentException("heartbeat_time is coded on 2 bytes can't be > 65535");
        }
        String value = String.valueOf(String.format("%04x", producerNodeID)) + String.format("%04x", heartbeat_time);
        return this.writeSDO(Integer.toHexString(nodeID), "1016", "1", "4", value);
    }
}

