/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenDAC
extends Module
implements PieceOfHardware {
    public static final double bitOverVolts = 3210.27287;
    CanOpenProxy tcpProxy;
    String serialNB;
    String nodeID;

    public CanOpenDAC() {
    }

    public CanOpenDAC(String nodeID, String serial) {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.serialNB = serial;
        this.nodeID = nodeID;
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public boolean isConfigOK() {
        return this.tcpProxy.isConfigOK(this);
    }

    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
    }

    public void writeAnalogOutput(int inputNB, int value) throws SDORequestError, HardwareNotDetectedException {
        if (!this.tcpProxy.isBooted(this)) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.getName(), this.nodeID);
            Module.log.error((Object)message);
            throw new HardwareNotDetectedException("CanOpenDAC is MISSING", this.getName(), this.nodeID, this.serialNB);
        }
        if (inputNB < 1 || inputNB > 4) {
            throw new IllegalArgumentException("CAN-CBX-AO412 : input has to be 1..4");
        }
        String valueInHexa = Integer.toHexString(value);
        String inputNBInHexa = Integer.toHexString(inputNB);
        this.tcpProxy.writeSDO(this.nodeID, "6411", inputNBInHexa, "2", valueInHexa);
    }

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/");
        sb.append(this.serialNB);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isConfigOK()) {
            sb.append("is booted");
            sb.append("/CanOpen NodeID in hexa= ");
            sb.append(this.nodeID);
            int x = Integer.getInteger(this.nodeID, 16);
            sb.append(" in decimal= ");
            sb.append(x);
        } else {
            sb.append("NOT DETECTED");
        }
        return sb.toString();
    }

    public String writeSDO(String index, String subindex, String length, String newValue) throws SDORequestError {
        return this.tcpProxy.writeSDO(this.nodeID, index, subindex, length, newValue);
    }

    public String readSDO(String index, String subindex) throws SDORequestError {
        return this.tcpProxy.readSDO(this.nodeID, index, subindex);
    }
}

