/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenADC
extends Module
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    String serialNB;
    String nodeID;
    public static final double adcVoltsPerBit = 0.3125;
    public static final double waterFreezeTemp = 273.15;

    public CanOpenADC() {
    }

    public CanOpenADC(String nodeID, String serial) {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.serialNB = serial;
        this.nodeID = nodeID;
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public boolean isConfigOK() {
        return this.tcpProxy.isConfigOK(this);
    }

    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
    }

    public String readAnalogInput(int inputNB) throws SDORequestError, HardwareNotDetectedException {
        Module.log.debug((Object)(String.valueOf(this.getName()) + " IS BOOTED AND CONFIG OK =" + this.isConfigOK()));
        if (this.tcpProxy.isBooted(this)) {
            if (inputNB < 1 || inputNB > 8) {
                throw new IllegalArgumentException("CAN-CBX-AI814 : input has to be 1..8");
            }
            String input = Integer.toHexString(inputNB);
            return this.tcpProxy.readSDO(this.nodeID, "6401", input);
        }
        String message = String.format("Module %s / nodeID=%s is UNREACHABLE", this.getName(), this.nodeID);
        Module.log.error((Object)message);
        throw new HardwareNotDetectedException("CanOpenADC MISSING", this.getName(), this.nodeID, this.serialNB);
    }

    public String readInputs() throws TimeoutException {
        return this.tcpProxy.sendCanOpen("srtr,1401,1402");
    }

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/");
        sb.append(this.serialNB);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isConfigOK()) {
            sb.append("is booted");
            sb.append("/CanOpen NodeID in hexa= ");
            sb.append(this.nodeID);
            int x = Integer.getInteger(this.nodeID, 16);
            sb.append(" in decimal= ");
            sb.append(x);
        } else {
            sb.append("NOT DETECTED");
        }
        return sb.toString();
    }
}

