/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is thrown when we receive an unexpected boot message from the field bus
 * after the end of the boot process.
 * @author virieux
 */
public class UnexpectedBootMessageReceived extends HardwareError {
    
    String nodeID;
    
    public UnexpectedBootMessageReceived(String msg, String nodeID) {
        super(msg);
        this.nodeID = nodeID;
    }
    
        @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" An unexpected boot message is arrived for node ID=");
        sb.append(this.nodeID);
        sb.append(" The node is already in the table of nodes : something weird has just happened. POWER FAILURE ?");
        return sb.toString();
    }
    
}
