/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is thrown when a sensor real or simulated returns a current
 * value out of range.
 * @author virieux
 */
public class SensorValueOutOfRangeException extends HardwareError {
    int minValue;
    int maxValue;
    int readValue;

    public SensorValueOutOfRangeException(String msg, String name, int minValue, int maxValue, int readValue) {
        super(msg, name);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.readValue = readValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":minValue=").append(minValue); 
        sb.append(",maxValue=").append(maxValue);
        sb.append(",readValue=").append(readValue);
        return sb.toString();
    }
    
    


    
}
