/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;

/**
 * This exception is thrown when the detected node ID of a piece of hardware identified by its serial number
 * doesn't match the node ID that is in the configuration DB.
 * @author virieux
 */
public class NodeIDMismatchException extends HardwareConfigurationError {
    CanOpenNode node;
    PieceOfHardware pieceOfHardware;

    /**
    * Constructs an instance of <code>NodeIDMismatchException</code> with the specified detail message.
    * @param msg the detail message.
    */

    
    public NodeIDMismatchException(CanOpenNode aNode, PieceOfHardware aPieceOfHardware) {
        super();
        this.node = aNode;
        this.pieceOfHardware = aPieceOfHardware;          
    }
    
    public NodeIDMismatchException(String msg, CanOpenNode aNode, PieceOfHardware aPieceOfHardware ) {
        super(msg);
        this.hardwareName = aPieceOfHardware.getName();
        this.node = aNode;
        this.pieceOfHardware = aPieceOfHardware;          
    }
    
    
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("A piece of hardware has been detected by its serial number, "
                + "but with a different node ID than in the configuration.");
        sb.append(hardwareName);
        sb.append(" serial NB=");
        sb.append(pieceOfHardware.getSerialNB());
        sb.append(" expected nodeID=");
        sb.append(pieceOfHardware.getNodeID());
        sb.append(" detected nodeID=");
        sb.append(this.node.getNodeID());
        return sb.toString();           
    }
}
