/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.errors;

/**
 * A generic hardware error.
 * @author virieux
 */
public class HardwareError extends Exception {

     /**
     * Name of the hardware
     */
    String hardwareName;

    public HardwareError() {
        super();
    }
    
     /**
     * Constructs an instance of <code>HardwareError</code> with the specified detail message.
     * @param msg the detail message.
     */
    public HardwareError(String msg) {
        super(msg);
    }
    
    /**
     * Constructs an instance of <code>HardwareError</code> with the specified detail message and
     * the name of the hardware in error.
     * @param msg
     * @param name 
     */
    public HardwareError(String msg, String name) {
        super(msg);
        this.hardwareName = name;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (!(this.hardwareName==null)) sb.append("Name of hardware in error: ").append(hardwareName);
        return sb.toString();
    }

}
