/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is thrown during the booting process when we were not able to see all the
 * pieces of hardware that we expected on the field bus during a given amount of time (timeout).
 * @author virieux
 */
public class ErrorInBootingHardwareProcess extends HardwareError {
    
    public final long timeout;
    public final long bootedNodesNB;
    public final long expectedNodesNB;
    
    public ErrorInBootingHardwareProcess(String msg, long bootingTime, long aBootedNodesNB, long anExpectedNodesNB) {
        super(msg);
        this.timeout = bootingTime;
        this.bootedNodesNB = aBootedNodesNB;
        this.expectedNodesNB = anExpectedNodesNB;
    }

    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Hardware is still missing after booting process timeout is over.");
        sb.append(" timeout=").append(this.timeout);
        sb.append(" Number of booted nodes=");
        sb.append(this.bootedNodesNB);
        sb.append(" Number of expected nodes=");
        sb.append(this.expectedNodesNB);
        return sb.toString();
    }
    
}
