/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

/**
 * This represents the motor that moves an autochanger truck along its rail.
 * @author virieux
 */
public class CanOpenTruckMotor extends SftTruckMotor {
    
     /**
     * The Digital Input-output which controls the motor.
     */
    CanOpenDIO dio;
    
    /**
     * Number of the output on the DIO8 where the motor is plugged
     */
    int outputNumeroToStandby;
    int outputNumeroToStandback;

    public CanOpenDIO getDio() {
        return dio;
    }

    public void setDio(CanOpenDIO dio) {
        this.dio = dio;
    }

    public int getOutputNumeroToStandback() {
        return outputNumeroToStandback;
    }

    public void setOutputNumeroToStandback(int outputNumeroToStandback) {
        this.outputNumeroToStandback = outputNumeroToStandback;
    }

    public int getOutputNumeroToStandby() {
        return outputNumeroToStandby;
    }

    public void setOutputNumeroToStandby(int outputNumeroToStandby) {
        this.outputNumeroToStandby = outputNumeroToStandby;
    }

    @Override
    public String moveToStandback() throws CanOpenError { 
        this.setMovingToStandback(true);
        return dio.tcpProxy.writeSDO(dio.nodeID, "6200", "1", "1", "1");

    }

    @Override
    public String moveToStandby() throws CanOpenError {
        this.setMovingToStandby(true);
        return dio.tcpProxy.writeSDO(dio.nodeID, "6200", "1", "1", "2");
    }

    @Override
    public String off() throws CanOpenError {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return dio.tcpProxy.writeSDO(dio.nodeID, "6200", "1", "1", "0");
    }
    
    

    
}
