/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

/**
 *
 * @author virieux
 */
public class CanOpenThermometer extends CanOpenSensor14bits implements Thermometer {

    @Override
    public double readTemperature() throws HardwareError {
        double temp = 0;
//        try {

            String valueInHexa = adc.readAnalogInput(numOfAnalogInput);
            log.debug("Value in HEXA=" + valueInHexa);
            int valueInt = Integer.parseInt(valueInHexa, 16);
            double voltage = valueInt * CanOpenADC.adcVoltsPerBit;
            log.debug("Input Value read on the ADC:" + valueInt);
            log.debug("Voltage = " + voltage + " volts");
            temp = (voltage / 10) - CanOpenADC.waterFreezeTemp;
            return temp;
//        } catch (HardwareNotDetectedException ex) {
//                log.error(ex);
//                this.getSubsystem().updateState(State.InError, getName() 
//                          +  " not booted or error in config.");
//        } catch (SDORequestError ex) {
//            log.error(getName() + " CanOpen Error in reading temperature " + ex.getMessage());
//            this.getSubsystem().updateState(State.InError,getName() + " CanOpen Error in reading temperature.");
//        }
//        return temp;
    }
    
}
