/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentError;

/**
 * This class set gathers the description of the real hardware and the tools (methods)
 * to give access to this hardware.
 * A new piece of hardware has to be added as a new field of this class, and the initModule method has to
 * be modified too.
 *
 * @author virieux
 */
public class BridgeToCanOpenHardware extends Module implements BridgeToHardware {
 
    
    private CanOpenProxy tcpProxy;

    private boolean hardwareInitialized = false;
    private boolean configurationChecked = false;
    
  
    // The hardware that we have to control
    
//        /*A third clamp motor that we have to control on the Single Filter test bench.*/
//    private CanOpenClampActuatorModule actuatorA;
    
    /*A third clamp motor that we have to control on the Single Filter test bench.*/
    private CanOpenClampActuatorModule clampActuatorXminus;
    
    /*Another clamp motor that we have to control on the Single Filter test bench.*/
    private CanOpenClampActuatorModule clampActuatorXplus;
    
    
    /*The ADC that we have to control on the Single Filter test bench.*/
    private CanOpenADC ai814;
    
    /*The DAC that we have to control on the Single Filter test bench.*/
    private CanOpenDAC ao412;
    
    /*The DAC that we have to control on the Single Filter test bench.*/
    private CanOpenDIO dio8n1;
    
    /*The DAC that we have to control on the Single Filter test bench.*/
    private CanOpenDIO dio8n2;


   
    

    
    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/
    //ALL THIS GETTERS AND SETTERS ARE FOR SPRING

    public CanOpenProxy getTcpProxy() {
        return tcpProxy;
    }

    public void setTcpProxy(CanOpenProxy tcpProxy) {
        this.tcpProxy = tcpProxy;
    }
    public CanOpenADC getAi814() {
        return ai814;
    }

    public void setAi814(CanOpenADC ai814) {
        this.ai814 = ai814;
    }

    public CanOpenDAC getAo412() {
        return ao412;
    }

    public void setAo412(CanOpenDAC ao412) {
        this.ao412 = ao412;
    }

    public CanOpenDIO getDio8n1() {
        return dio8n1;
    }

    public void setDio8n1(CanOpenDIO dio8n1) {
        this.dio8n1 = dio8n1;
    }

    public CanOpenDIO getDio8n2() {
        return dio8n2;
    }

    public void setDio8n2(CanOpenDIO dio8n2) {
        this.dio8n2 = dio8n2;
    }


    
//    public CanOpenClampActuatorModule getActuatorA() {
//        return actuatorA;
//    }
//
//    public void setActuatorA(CanOpenClampActuatorModule actuatorA) {
//        this.actuatorA = actuatorA;
//    }
       /**
     * @return the actuator
     */
    public CanOpenClampActuatorModule getClampActuatorXplus() {
        return clampActuatorXplus;
    }

    /**
     * @param actuator the actuator to set
     */
    public void setClampActuatorXplus(CanOpenClampActuatorModule actuator) {
        this.clampActuatorXplus = actuator;
    }
    
    /**
    * @return the actuator
    */
    public CanOpenClampActuatorModule getClampActuatorXminus() {
        return clampActuatorXminus;
    }

    /**
     * @param actuator the actuator to set
     */
    public void setClampActuatorXminus(CanOpenClampActuatorModule actuator) {
        this.clampActuatorXminus = actuator;
    }
    
    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/
    
     /**
     * This method returns true if the C-Wrapper is connected to the tcp proxy.
     * The C-Wrapper has to send the tcpProxy clientName as a keyword before
     * any communication can begin. So if the C-Wrapper doesn't send the good
     * keyword or if it doesn't connect to the tcp proxy, this method returns 
     * false.
     */
    @Override
    public boolean isCWrapperConnected() {
        return tcpProxy.isReady(tcpProxy.getMyClientName());
    }
    
    
    /**
     * returns true if the hardware is booted, identified and initialized.
     */
    @Override
    public boolean isHardwareReady() {
        return tcpProxy.isHardwareReady();
    }
    
    @Override
    public void initModule() {
        
        log.debug("INIT MODULE" + getName());
        
        PieceOfHardware[] hardwareList = {clampActuatorXminus, clampActuatorXplus,  ai814, ao412, dio8n1, dio8n2};        
        tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        tcpProxy.setExpectedNodesNB(numberOfNodes);
        log.debug("Number of pieces of hardware expected =" + numberOfNodes);
        
        
        //we have to read the errors table for the maxon motor and can open devices.
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        } catch (DeploymentError ex) {
            log.error(ex.getMessage() + ": Could not load CanOpen Error Tables");
            this.getSubsystem().updateState(State.InError, "Could not load CanOpen Error Tables");
        }
    }
    
    
    
    public void shutdown() {
        tcpProxy.stop();
        this.getSubsystem().shutdown();
    }
    
     /**
     * For engineering mode, this method can be used to send Can Open commands
     * to the Wrapper. 
     * @param command A Can Open command that the Wrapper should understand.
     * @return the response from the Wrapper
     */
    public Object sendCanOpen(String command) throws InterruptedException, TimeoutException {
        return tcpProxy.sendCanOpen(command);
    }
}
