package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.simulation.ErrorState;
import org.lsst.ccs.subsystems.fcs.simulation.RunningState;
import org.lsst.ccs.subsystems.fcs.simulation.StopState;



public interface EngineState {
	
	static public final EngineState RUNNING = new RunningState();
	static public final EngineState STOP = new StopState();
	static public final EngineState ERROR = new ErrorState();

	/**
	 * Send the command go to engine e for t milliseconds in a given rotation way.
	 * @param e : engine
	 * @param t : in milliseconds
	 * @param runningWay rotation way
	 */
	public abstract String go(Motor m, double t, RunningWay runningWay);

	public abstract String stop(Motor m);

	public abstract String error(Motor m);

	/**
	 * This method compute the displacement of the mobil mechanical item
	 * the engine moves during a period and in a given rotation way.
	 * @param engine
	 * @param period in milliseconds
	 * @param runningWay
	 * @return
	 */
	public abstract double computeDisplacement(Motor m, double period, RunningWay runningWay);
    

}
