package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;

public interface AutoChanger {
			
	public String goToPosition(double trucksPositionOnline) throws BadCommandException;

	public String stop();

	public double getTrucksPosition();

	public Filter getFilterOnTrucks();

	public String moveFilterToOnline(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareError, CanOpenError;
	
	public String moveFilterToStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareError, CanOpenError;
	
	public String grabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareError, CanOpenError;

	public String ungrabFilterAtStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareError, CanOpenError;

	public String closeLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareError, CanOpenError;
	
	public String openLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareError, CanOpenError; 

	public void locateTrucks();
        
        public boolean isAtStandby();
	
}
