/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ITuple;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.tuple.Tuple;
import java.util.Random;

public abstract class FunctionMcStudy {
    public static ITuple generateTuple(Function f, int nEntries) {
        double maxHeight = f.maxValue();
        if (maxHeight == Double.NaN) {
            maxHeight = FunctionMcStudy.evaluateMaxHeight(f, nEntries / 10);
        }
        return FunctionMcStudy.generateTuple(f, nEntries, maxHeight *= 1.2);
    }

    /*
     * Unable to fully structure code
     */
    protected static ITuple generateTuple(Function f, int nEntries, double maxHeight) {
        dim = f.numberOfDependents();
        deps = new Dependent[dim];
        columnNames = new String[dim + 1];
        columnTypes = new Class[dim + 1];
        for (i = 0; i < dim; ++i) {
            columnNames[i] = f.getDependent(i).name();
            columnTypes[i] = Double.TYPE;
            deps[i] = f.getDependent(i);
        }
        columnNames[dim] = "functionValue";
        columnTypes[dim] = Double.TYPE;
        t = new Tuple("tup", "", columnNames, columnTypes, "");
        r = new Random();
        count = false;
        while (true) {
            for (j = 0; j < dim; ++j) {
                x = deps[j].range().generatePoint();
                deps[j].setValue(x);
                t.fill(j, x);
            }
            x = f.functionValue();
            t.fill(dim, x);
            if (x > maxHeight) {
                System.out.println("Function value " + x + " exceeds maximum " + maxHeight + ". Increasing maximum by 20% and restarting the MC study.");
                return FunctionMcStudy.generateTuple(f, nEntries, maxHeight * 1.2);
            }
            if (!(r.nextDouble() * maxHeight < x)) ** continue;
            t.addRow();
            if (t.rows() == nEntries) break;
        }
        return t;
    }

    private static double evaluateMaxHeight(Function f, int entries) {
        int dim = f.numberOfDependents();
        Dependent[] deps = new Dependent[dim];
        for (int i = 0; i < dim; ++i) {
            deps[i] = f.getDependent(i);
        }
        double maxHeight = 0.0;
        for (int i = 0; i < entries; ++i) {
            double x;
            for (int j = 0; j < dim; ++j) {
                x = deps[j].range().generatePoint();
                deps[j].setValue(x);
            }
            x = f.functionValue();
            if (!(x > maxHeight)) continue;
            maxHeight = x;
        }
        return maxHeight;
    }
}

